% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send}
\alias{send}
\title{Send}
\usage{
send(con, data, mode = c("serial", "raw", "next"), block = NULL)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if mode = \sQuote{raw}).}

\item{mode}{[default 'serial'] character value or integer equivalent - one of
\sQuote{serial} (1L) to send serialised R objects, \sQuote{raw} (2L) to
send atomic vectors of any type as a raw byte vector, or \sQuote{next}
(3L) - see \sQuote{Send Modes} section below. For Streams, \sQuote{raw}
is the only option and this argument is ignored.}

\item{block}{[default NULL] which applies the connection default (see section
\sQuote{Blocking} below). Specify logical TRUE to block until successful
or FALSE to return immediately even if unsuccessful (e.g. if no
connection is available), or else an integer value specifying the maximum
time to block in milliseconds, after which the operation will time out.}
}
\value{
Integer exit code (zero on success).
}
\description{
Send data over a connection (Socket, Context or Stream).
}
\section{Blocking}{


    For Sockets and Contexts: the default behaviour is non-blocking with
    \code{block = FALSE}. This will return immediately with an error if the
    message could not be queued for sending. Certain protocol / transport
    combinations may limit the number of messages that can be queued if they
    have yet to be received.

    For Streams: the default behaviour is blocking with \code{block = TRUE}.
    This will wait until the send has completed. Set a timeout to ensure that
    the function returns under all scenarios. As the underlying
    implementation uses an asynchronous send with a wait, it is recommended
    to set a small positive value for \code{block} rather than FALSE.
}

\section{Send Modes}{


    The default mode \sQuote{serial} sends serialised R objects to ensure
    perfect reproducibility within R. When receiving, the corresponding mode
    \sQuote{serial} should be used.

    Mode \sQuote{raw} sends atomic vectors of any type as a raw byte vector,
    and must be used when interfacing with external applications or raw
    system sockets, where R serialization is not in use. When receiving, the
    mode corresponding to the vector sent should be used.

    Mode \sQuote{next} sends serialised R objects, with native extensions
    enabled by \code{\link{next_config}}. This configures custom
    serialization and unserialization functions for reference objects. When
    receiving, mode \sQuote{serial} should be used as \sQuote{next} sends are
    fully compatible.
}

\examples{
pub <- socket("pub", dial = "inproc://nanonext")

send(pub, data.frame(a = 1, b = 2))
send(pub, c(10.1, 20.2, 30.3), mode = "raw", block = 100)

close(pub)

req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctx <- context(req)
send(ctx, data.frame(a = 1, b = 2), block = 100)

msg <- recv_aio(rep, timeout = 100)
send(ctx, c(1.1, 2.2, 3.3), mode = "raw", block = 100)

close(req)
close(rep)

}
\seealso{
\code{\link{send_aio}} for asynchronous send.
}
