% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_random.R
\name{normalize_random}
\alias{normalize_random}
\title{Normalize data using random reference samples}
\usage{
normalize_random(x, ref, n = 1, strata = NULL, seed = NULL)
}
\arguments{
\item{x}{target data}

\item{ref}{reference data}

\item{n}{number of random reference samples to select for normalization}

\item{strata}{a grouping variable for stratified random sampling. If \code{strata}
has \code{k} levels, then \code{n * k} random samples are selected.}

\item{seed}{random seed for reproducibility}
}
\value{
normalized gene expression
}
\description{
Normalize nanostring gene expression using randomly chosen samples
for the reference-based approach for batch adjustment.
}
\details{
The number of randomly chosen numbers can be selected, and optionally a
\code{strata} can be specified such that \code{n} reference samples are selected from
each level (like a stratified bootstrap). In relation to the reference
method, the random samples removed from \code{ref} form \code{R1}, the random samples
removed from \code{x} form \code{R2}, and the remaining samples from \code{x} form \code{Y}. See
\code{refMethod()} for details.

In subsequent analyses, we refer to a method using \code{normalize_random(n)} as
the "Random n" method.
}
\author{
Derek Chiu
}
