% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.r
\name{map}
\alias{map}
\title{Maps a function along an array preserving its structure}
\usage{
map(X, along, FUN, subsets = base::rep(1, dim(X)[along]), drop = TRUE,
  ...)
}
\arguments{
\item{X}{An n-dimensional array}

\item{along}{Along which axis to apply the function}

\item{FUN}{A function that maps a vector to the same length or a scalar}

\item{subsets}{Whether to apply \code{FUN} along the whole axis or subsets thereof}

\item{drop}{Remove unused dimensions after mapping; default: TRUE}

\item{...}{Other arguments passed to \code{FUN}}
}
\value{
An array where \code{FUN} has been applied
}
\description{
Maps a function along an array preserving its structure
}
