% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cup_race_data.R
\docType{data}
\name{cup_race_data}
\alias{cup_race_data}
\title{NASCAR Cup Series Results}
\format{
A data frame with 97,474 rows and 23 variables:
\describe{
\item{season}{num: Racing season (1949-2023)}
\item{race}{num: Chronological race number for that season (1-62)}
\item{site}{chr: Location of the race (city)}
\item{track}{chr: Race track name}
\item{track_length}{num: Race track length, in miles}
\item{track_type}{chr: Race track surface (dirt track, paved track, road course)}
\item{finish}{num: Finish position in the race}
\item{start}{num: Start position in the race}
\item{driver}{chr: Driver's name}
\item{manufacturer}{chr: Car manufacturer (e.g., "Chevrolet", "Ford", "Toyota")}
\item{car_number}{chr: Car number}
\item{owner}{chr: Car owner}
\item{sponsor}{chr: Car sponsor}
\item{win}{num: Indicator variable for win; \code{1} = win, \code{0} = did not win}
\item{top_5}{num: Indicator variable for finish position in 5th place or better; \code{1} = yes, \code{0} = no}
\item{top_10}{num: Indicator variable for finish position in 10th place or better; \code{1} = yes, \code{0} = no}
\item{top_20}{num: Indicator variable for finish position in 20th place or better; \code{1} = yes, \code{0} = no}
\item{laps}{num: Number of laps completed in the race}
\item{laps_led}{num: Number of laps led in the race}
\item{status}{chr: Status at the end of the race (e.g., "Running", "Accident"), if available}
\item{money}{num: Total race earning (in dollars) not including bonus money, if available. No available data beginning with the 2016 season.}
\item{pts}{num: Points earned in the race. Available beginning with the 1975 season.}
\item{playoff_pts}{num: Playoff points earned in the race. Available beginning with the 2017 season.}
}
}
\source{
\url{https://www.driveraverages.com/nascar/nascar-stats.php}

\url{https://en.wikipedia.org/wiki/NASCAR_Cup_Series}
}
\usage{
cup_race_data
}
\description{
A collection of NASCAR's top level competitive race series results from the first race in 1949 through the completion of the 2023 season. The series has undergone several name changes, including its start as the Strictly Stock and Grand National to Winston Cup through the current NASCAR Cup Series.
}
\examples{
data(cup_race_data)
}
\keyword{datasets}
