% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_team.R
\name{get_team_info}
\alias{get_team_info}
\title{Get NASCAR team statistics}
\usage{
get_team_info(team, series = "all", type = "summary")
}
\arguments{
\item{team}{Character string specifying an team name (case-insensitive, fuzzy matching
available)}

\item{series}{Character string specifying the racing series to analyze. Must be
one of:
\itemize{
\item 'all' (default)
\item 'Cup'
\item 'Xfinity'
\item 'Truck'
}}

\item{type}{Character string specifying the type of summary to return. Must be
one of:
\itemize{
\item 'summary' (default): Career statistics grouped by series
\item 'season': Season-by-season statistics for each series
\item 'all': Complete race-by-race data
}}
}
\value{
A tibble containing team statistics based on the specified type:
\itemize{
\item For type = 'summary': Career statistics grouped by series
\item For type = 'season': Season-by-season breakdown
\item For type = 'all': Complete race-by-race data
}
}
\description{
Retrieves and summarizes NASCAR race statistics for a specified team across
different racing series. The function provides flexibility in viewing career
summaries, season-by-season breakdowns, or complete race-by-race data.
}
\examples{
if (interactive()) {
  # Get career summary for Joe Gibbs Racing across all series
  get_team_info("Joe Gibbs Racing")

  # Get Cup series statistics only
  get_team_info("Joe Gibbs Racing", series = "cup")

  # Get season-by-season breakdown for Truck series
  get_team_info("Joe Gibbs Racing", series = "truck", type = "season")
}

}
