% Generated by roxygen2 (4.0.2): do not edit by hand
\name{templatebrain-meths}
\alias{as.character.templatebrain}
\alias{as.im3d.templatebrain}
\alias{boundingbox.templatebrain}
\alias{dim.templatebrain}
\alias{is.templatebrain}
\alias{origin.templatebrain}
\alias{print.templatebrain}
\alias{templatebrain-meths}
\alias{voxdims.templatebrain}
\title{Template brain methods}
\usage{
is.templatebrain(x)

\method{as.character}{templatebrain}(x, field = c("regName", "name"), ...)

\method{print}{templatebrain}(x, ...)

\method{as.im3d}{templatebrain}(x, ...)

\method{origin}{templatebrain}(x, ...)

\method{dim}{templatebrain}(x, ...)

\method{voxdims}{templatebrain}(x, ...)

\method{boundingbox}{templatebrain}(x, ...)
}
\arguments{
\item{x}{An object (usually a templatebrain)}

\item{field}{Which field to use (defaults to \code{'regName'})}

\item{...}{additional arguments for methods}
}
\value{
logical

character vector
}
\description{
\code{is.templatebrain} tests if object is of class templatebrain

\code{as.character.templatebrain} converts template brain to
  character vector representation (normally used to extract the short name
  i.e. \code{regName}).

\code{print.templatebrain} prints templatebrain information in
  human-readable form

\code{as.im3d} converts a template brain to a \code{nat::im3d}
  object; this is probably useful for developers.

\code{origin} extracts the space origin of a templatebrain
  object.

\code{dim} extracts the dimensions (in number of pixels) of the
  image associated with a templatebrain object.

\code{voxdims} extracts the dimensions (in number of pixels) of
  the image associated with a templatebrain object.

\code{boundingbox} extracts the boundingbox (in calibrated
  spatial units, typically microns) of the image associated with a
  templatebrain object. See \code{\link[nat]{boundingbox}} for details.
}
\examples{
data(FCWB.demo)
is.templatebrain(FCWB.demo)
origin(FCWB.demo)
dim(FCWB.demo)
voxdims(FCWB.demo)
boundingbox(FCWB.demo)
}
\seealso{
\code{\link[nat]{im3d}}

\code{\link[nat]{origin}}

\code{\link[nat]{voxdims}}

\code{\link[nat]{boundingbox}}
}

