% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/transformation.R
\name{xform_brain}
\alias{xform_brain}
\title{Transform 3D object between template brains}
\usage{
xform_brain(x, sample, reference, via = NULL, imagedata = is.character(x),
  checkboth = NULL, ...)
}
\arguments{
\item{x}{the 3D object to be transformed}

\item{sample}{Source template brain (e.g. IS2) that data is currently in.}

\item{reference}{Target template brain (e.g. IS2) that data should be
transformed into.}

\item{via}{optional intermediate brain to use when there is no direct
bridging registration.}

\item{imagedata}{Whether \code{x} should be treated as image data (presently
only supported as a file on disk or 3D object vertices - see details).}

\item{checkboth}{When \code{TRUE} will look for registrations in both
directions. See details.}

\item{...}{extra arguments to pass to \code{\link[nat]{xform}}.}
}
\description{
Transform 3D object between template brains
}
\details{
NB the \code{sample}, \code{reference} and \code{via} brains can
  either be \code{templatebrain} objects or a character string containing the
  short name of the template e.g. \code{"IS2"}.

  The significance of the \code{imagedata} and \code{checkboth} arguments is
  that CMTK registrations are not directly invertible although they can be
  numerically inverted in most cases (unless there are regions where folding
  occurred). For image data, numerical inversion is \emph{much} slower.

  You can control whether you want to allow inverse registrations manually by
  setting \code{checkboth} explicitly. Otherwise when \code{checkboth=NULL}
  the following default behaviour occurs: \itemize{

  \item when \code{via=NULL} \code{checkboth=T} but a warning will be given
  if an inversion must be used.

  \item when \code{via} is specified then \code{checkboth=T} but a warning
  will be given if an inversion must be used.

  }
}
\examples{
## depends on nat.flybrains package and system CMTK installation
\dontrun{
## reformat neurons
##
library(nat.flybrains)
# Plot Kenyon cells in their original FCWB template brain
nopen3d()
plot3d(kcs20)
plot3d(FCWB)
# Convert to JFCR2 template brain
kcs20.jfrc2=xform_brain(kcs20, sample = FCWB, reference=JFRC2, .progress='text')
# now plot in the new JFRC2 space
nopen3d()
plot3d(kcs20.jfrc2)
plot3d(JFRC2)
# compare with the untransformed neurons
plot3d(kcs20)
# plot with neuropil sub regions for the left mushroom body
clear3d()
plot3d(kcs20.jfrc2)
# nb "MB.*_L" is a regular expression
plot3d(JFRC2NP.surf, "MB.*_L", alpha=0.3)
# compare with originals - briging registration is no perfect in peduncle
nopen3d()
plot3d(kcs20)
plot3d(FCWBNP.surf, "MB.*_L", alpha=0.3)


## reformat image examples
# see ?cmtk.reformatx for details of all additional arguments
xform_brain('in.nrrd', sample=FCWB, ref=JFRC2, output='out.nrrd', Verbose=F)

# use nearest neighbour interpolation for label field
xform_brain('labels.nrrd', sample=FCWB, ref=JFRC2, output='out.nrrd', interpolation='nn')

# use binary mask to restrict (and speed up) reformatting
xform_brain('in.nrrd', sample=FCWB, ref=JFRC2, output='out.nrrd', mask='neuropil.nrrd')
}
}

