% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_repos.R
\name{add_reglist}
\alias{add_reglist}
\title{Add reglist object describing a bridging/mirroring registration}
\usage{
add_reglist(x, reference = NULL, sample = NULL, mirror = NULL,
  temp = TRUE, ...)
}
\arguments{
\item{x}{A single \code{\link[nat]{reglist}} object (which )}

\item{reference, sample}{The reference and sample brains (in \code{character}
or \code{templatebrain} form) for a bridging registration.}

\item{mirror}{The reference brain (in \code{character} or
\code{templatebrain} form) for a mirroring registration.}

\item{temp}{Whether to store the on disk representation in a session-specific
temporary folder (that will be removed when R closes). Defaults to
\code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link{saveRDS}} e.g. to
control compression when the reglist object is saved to disk.}
}
\description{
By specifying either \code{reference, sample} \emph{or}
  \code{mirror} arguments, you can add a bridging or mirroring registration,
  respectively, to the list of those in use for \code{\link{xform_brain}} and
  \code{\link{mirror_brain}}.
}
\examples{
\dontrun{
library(nat.flybrains)
# mirroring registration for a specific template brain object
add_reglist(mirroring, mirror=JFRC2013)
# equivalent but withhout needing to construct the template
add_reglist(mirroring, mirror="JFRC2013")

# add a bridging registration between two brains
add_reglist(bridging, reference=JFRC2, sample=JFRC2013)

}
}
\seealso{
add_reg_folders
}
