% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_balance.R
\name{get_stand_diffs}
\alias{get_stand_diffs}
\title{Calculate standardized differences}
\usage{
get_stand_diffs(
  data,
  z,
  selected,
  st = NULL,
  ist = NULL,
  treated = 1,
  control = 0,
  denom_variance = "treated"
)
}
\arguments{
\item{data}{A data frame with columns for which the standardized differences should be calculated.}

\item{z}{a factor with the \code{i}th entry equal to the treatment of unit \code{i}.}

\item{selected}{a boolean vector including whether each unit was selected as part of the treated and control
groups for analysis. Should be the same length as \code{z} and typically comes from the results of
\code{\link{optimize_controls}()}.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{ist}{The specific stratum for which the standardized differences should be calculated.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}

\item{control}{which treatment value should be considered the control units. This
must be one of the values of \code{z}.}

\item{denom_variance}{character stating what variance to use in the standardization:
either the default "treated", meaning the standardization will use the
treated variance (across all strata), where the treated group is declared in
the \code{treated} argument, or "pooled", meaning
the standardization will use the average of the variances of each treatment group.}
}
\value{
data frame containing two columns, one for standardized differences before
choosing a subset of controls, and one for after. The rows pertain to covariates.
}
\description{
Calculate standardized differences in means between treated and control groups,
before and after refining the control group. Used within the \code{\link{check_balance}} function.
}
\keyword{internal}
