% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand.R
\name{stand}
\alias{stand}
\title{Standardize covariate vector for balance constraint}
\usage{
stand(z, x, denom_variance = "treated", treated = 1, autogen_missing = 50)
}
\arguments{
\item{z}{a factor with the \code{i}th entry equal to the treatment of unit \code{i}.}

\item{x}{a covariate vector with \code{i}th entry equal to the
covariate value of unit \code{i}. This should have the same order of units and
length as \code{z}.}

\item{denom_variance}{character stating what variance to use in the standardization:
either the default "treated", meaning the standardization will use the
treated variance (across all strata), where the treated group is declared in
the \code{treated} argument, or "pooled", meaning
the standardization will use the average of the variances of each treatment group.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}

\item{autogen_missing}{whether to automatically generate missingness constraint
and how heavily to prioritize it. Should be a numeric
or \code{NULL} value. \code{NULL} indicates that
a constraint to balance the rate of missingness (denoted by \code{NA}
in \code{x}) should not be automatically generated. Note that this is not
recommended unless the user has already accounted for missing values.
If not \code{NULL}, \code{autogen_missing} should be a numeric stating how heavily
to prioritize generated missingness constraints over covariate constraint.
The default is 50.}
}
\value{
A list with two components:
\describe{
\item{covariate}{a balance constraint for the standardized covariate values
  of all unites.}
\item{missingness}{a corresponding balance constraint for the rate of missingness if
\code{autogen_missing} not \code{NULL}, otherwise \code{NULL}.}
}
}
\description{
This function is used by \code{\link{generate_constraints}()} to standardize
covariate vectors to become balance constraints.
The function divides the covariate values by the treated or average group
standard deviation (across strata).
}
