% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nauf_trms_fr_x_z.R
\name{nauf_glFormula}
\alias{nauf_glFormula}
\alias{nauf_lFormula}
\title{Create a model frame and fixed and random effects model matrices using \code{nauf} contrasts.}
\usage{
nauf_glFormula(formula, data = NULL, family = gaussian, subset, weights,
  na.action = na.pass, offset, contrasts = NULL, mustart, etastart,
  control = lme4::glmerControl(), ncs_scale = attr(formula,
  "standardized.scale"), ...)

nauf_lFormula(formula, data = NULL, REML = TRUE, subset, weights,
  na.action = na.pass, offset, contrasts = NULL,
  control = lme4::lmerControl(), ncs_scale = attr(formula,
  "standardized.scale"), ...)
}
\arguments{
\item{formula, data, family, REML, subset, weights, offset, control, mustart, etastart, ...}{See \code{\link[lme4]{glFormula}}.}

\item{na.action, contrasts}{Changes from default values are ignored.  See
\code{\link{nauf_model.frame}}.}

\item{ncs_scale}{A positive number to be passed as the \code{scale} argument
to \code{\link[standardize]{named_contr_sum}} for all unordered factors.
See \code{\link{nauf_model.frame}}.}
}
\value{
A list with the following elements:
\describe{
  \item{fr}{The model frame (with class \code{nauf.frame}).
    See \code{\link{nauf_model.frame}}.}
  \item{X}{The fixed effects model matrix with \code{\link{nauf_contrasts}}
    applied. See \code{\link{nauf_model.matrix}}.}
  \item{reTrms}{A list containing the random effects model matrix and other
    information about the random effects structure.  The elements of the list
    have the same structure as that returned by \code{\link[lme4]{mkReTrms}},
    but incorportating \code{\link{nauf_contrasts}}.}
  \item{REML}{(\code{nauf_lFormula} only): A logical indicating if restricted
    maximum likelihood was used (copy of argument).}
  \item{family}{(\code{nauf_glFormula} only): The regression family (copy
    of argument).}
  \item{formula}{The \code{formula} argument, but with any double vertical
    bars expanded (e.g. \code{(1 + x || subj)} becomes
    \code{(1 | subj) + (0 + x | subj)}).}
  \item{wmsgs}{Warning messages (if any).}
}
}
\description{
The same as the \code{lme4} \code{\link[lme4]{modular}} functions
\code{glFormula} and \code{lFormula}, but implementing
\code{\link{nauf_contrasts}}.  \code{nauf_lFormula} is used for linear mixed
effects regressions (i.e. those that would be fit with
\code{\link{nauf_lmer}}) and \code{nauf_glFormula} is used for genarlized
linear mixed effects regressions (i.e. those that would be fit with
\code{\link{nauf_glmer}} or \code{\link{nauf_glmer.nb}}).  Both of the
functions contain a call to \code{nauf_mkReTrms}, which serves the same
purpose as the \code{lme4} function \code{\link[lme4]{mkReTrms}}, but with
\code{\link{nauf_contrasts}}, and, while \code{\link[lme4]{mkReTrms}} is
exported by \code{lme4}, \code{nauf_mkReTrms} is an internal function in the
\code{nauf} package.
}
\examples{
dat <- plosives
dat$spont[dat$dialect == "Valladolid"] <- NA
dat_form <- intdiff ~ voicing * dialect * spont +
  (1 + voicing * spont | speaker) + (1 + dialect | item)
sobj <- standardize(dat_form, dat)
lmod <- nauf_lFormula(sobj$formula, sobj$data)

vless <- droplevels(subset(dat, voicing == "Voiceless"))
vless$fully_voiced <- vless$vdur == 0
vless_form <- fully_voiced ~ dialect * spont +
  (1 + spont | speaker) + (1 + dialect | item)
svless <- standardize(vless_form, vless, family = binomial)
glmod <- nauf_glFormula(svless$formula, svless$data, family = binomial)

}
\seealso{
\code{\link{nauf_contrasts}} for a description of the contrasts
  applied to unordered factors; \code{\link{nauf_model.frame}} and
  \code{\link{nauf_model.matrix}} for the creation of the \code{fr} and
  \code{X} elements of the returned list, respectively; and
  \code{\link{nauf_lmer}}, \code{\link{nauf_glmer.nb}}, and
  \code{\link{nauf_glmer}} for fitting mixed effects regressions with gaussian,
  negative binomial, and all other families, respectively.
}

