% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indToPair.R
\name{indToPair}
\alias{indToPair}
\title{Transforms a dataset of individuals to a dataset of pairs}
\usage{
indToPair(
  indData,
  indIDVar,
  separator = "_",
  dateVar = NULL,
  units = c("mins", "hours", "days", "weeks"),
  ordered = FALSE
)
}
\arguments{
\item{indData}{An individual-level dataframe.}

\item{indIDVar}{The name (in quotes) of the column with the individual ID.}

\item{separator}{The character to be used to separate the individual IDs when creating
the pairID.}

\item{dateVar}{The name (in quotes) of the column with the dates that the individuals are observed
(optional unless \code{ordered = TRUE}). This column must be a date or date-time (POSIXt) object.
If supplied, the time difference between individuals will be calculated in the units specified.}

\item{units}{The units for the time difference, only necessary if \code{dateVar} is supplied.
Must be one of \code{"mins", "hours", "days", "weeks"}.}

\item{ordered}{A logical indicating if a set of ordered pairs should be returned
(\code{<dateVar>.1} before \code{<dateVar>.2} or \code{<dateVar>.1} = \code{<dateVar>.2}).
If FALSE a dataframe of all pairs will be returned}
}
\value{
A dataframe of either all possible pairs of individuals (\code{ordered = FALSE}) or ordered
pairs of individuals (\code{ordered = TRUE}). The dataframe will have all of the original variables
with suffixes ".1" and ".2" corresponding to the original values of 
\code{<indIDVar>.1} and \code{<indIDVar>.2}.

Added to the dataframe will be a column called \code{pairID} which is \code{<indIDVar>.1}
and \code{<indIDVar>.2} separated by \code{separator}.

If dateVar is provided the dataframe will also include variables \code{<dateVar>.Diff} giving 
the difference of time of \code{dateVar} for \code{<indIDVar>.1} and \code{<indIDVar>.2} 
in the units specified
}
\description{
The function \code{indToPair} takes a dataset of observations (such as individuals in an infectious
disease outbreak) and transforms it into a dataset of pairs.
}
\details{
The function requires an id column: \code{indIDVar} to identify the individual observations.
The resulting pair-level dataframe will have a \code{pairID} column which combines the individual IDs
for that pair.

The function can either output all possible pairs (\code{ordered = FALSE}) or only ordered pairs 
(\code{ordered = TRUE}) where the ordered is determined by a date variable (\code{dateVar}).
If \code{orded = TRUE}, then \code{dateVar} must be provided and if \code{ordered = FALSE},
it is optional. In both cases, if \code{dateVar} is provided, the output will include the time
difference between the individuals in the pair in the \code{units} specified ("mins", "hours", "days", "weeks").
}
\examples{
## Create a dataset of all pairs with no date variable
pairU <- indToPair(indData = indData, indIDVar = "individualID")

## Create a dataset of all pairs with a date variable
pairUD <- indToPair(indData = indData, indIDVar = "individualID",
                      dateVar = "infectionDate", units = "days")

## Create a dataset of ordered pairs
pairO <- indToPair(indData = indData, indIDVar = "individualID",
                     dateVar = "infectionDate", units = "days", ordered = TRUE)

}
