% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbconv.R
\name{pnbconv}
\alias{pnbconv}
\title{Calculates the CDF for the convolution of arbitrary negative binomial random variables.}
\usage{
pnbconv(
  quants,
  mus,
  ps,
  phis,
  method = c("exact", "moments", "saddlepoint"),
  n.terms = 1000,
  n.cores = 1,
  tolerance = 0.001,
  normalize = TRUE
)
}
\arguments{
\item{quants}{Vector of quantiles.}

\item{mus}{Vector of individual mean values}

\item{ps}{Vector of individual probabilities of success.}

\item{phis}{Vector of individual dispersion parameters. Equivalent to 'size' in dnbinom.}

\item{method}{The method by which to evaluate the PMF. One of "exact", "moments", or "saddlepoint".}

\item{n.terms}{The number of terms to include in the series for evaluating the PMF at a given number of counts. Defaults to 1000.}

\item{n.cores}{The number of CPU cores to use in the evaluation. Allows parallelization.}

\item{tolerance}{The acceptable difference between the sum of the K distribution and 1.}

\item{normalize}{Boolean. If TRUE, the PMF is normalized to sum to 1.}
}
\value{
A numeric vector of cumulative probability densities.
}
\description{
Calculates the CDF for the convolution of arbitrary negative binomial random variables.
}
\examples{
pnbconv(quants = 200, mus = c(100, 10), phis = c(5, 8), method = "exact")

}
