% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_teams.R
\name{get_teams}
\alias{get_teams}
\title{Extract data frame of team names, IDs, conference, division, and season}
\usage{
get_teams(year = NULL, division = 1, sport = "WVB")
}
\arguments{
\item{year}{Single numeric year for fall of desired season.}

\item{division}{NCAA division (must be 1, 2, or 3).}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}
}
\value{
Returns a data frame of all teams, their team ID, division, conference,
and season.
}
\description{
NCAA datasets use a unique ID for each sport, team, and season.
This function extracts team names, IDs, and conferences for each NCAA team in
a division. However, you should not need to use this function for volleyball
data from 2020-2024, as it has been used to generate \link{wvb_teams}
and \link{mvb_teams}. However, it is available to use for other
sports, using the appropriate three letter sport code drawn from
\link{ncaa_sports} (e.g., men's baseball is "MBA").
}
\note{
This function is a modification of the \code{ncaa_teams()} function from the
\href{https://billpetti.github.io/baseballr/}{\code{{baseballr}}} package.
}
