% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinAUC.R
\name{LinAUC}
\alias{LinAUC}
\title{Area Under the Curve(AUC) and Area Under the first Moment Curve(AUMC) by
linear trapezoidal method}
\usage{
LinAUC(x, y)
}
\arguments{
\item{x}{vector values of independent variable, usually time}

\item{y}{vector values of dependent variable, usually concentration}
}
\value{
\item{AUC}{area under the curve} \item{AUMC}{area under the first
moment curve}
}
\description{
It calculates AUC and AUMC using linear trapezoidal method
}
\details{
This function returns AUC and AUMC by linear trapezoidal method.
}
\examples{
LinAUC(Theoph[Theoph$Subject==1, "Time"],Theoph[Theoph$Subject==1, "conc"])
AUC(Theoph[Theoph$Subject==1, "Time"],Theoph[Theoph$Subject==1, "conc"]) # compare the last line
}
\references{
\enumerate{ \item Gabrielsson J, Weiner D. Pharmacokinetic and
Pharmacodynamic Data Analysis - Concepts and Applications. 5th ed. 2016.
\item Shargel L, Yu A. Applied Biopharmaceutics and Pharmacokinetics. 7th
ed. 2015.  \item Rowland M, Tozer TN. Clinical Pharmacokinetics and
Pharmacodynamics - Concepts and Applications. 4th ed. 2011. \item Gibaldi M,
Perrier D. Pharmacokinetics. 2nd ed. revised and expanded. 1982. }
}
\seealso{
\code{\link{LogAUC}},\code{\link{AUC}}
}
\keyword{AUC}

