\name{nc.copy.atts}
\alias{nc.copy.atts}
\title{Copy attributes from one variable in one file to another file}
\usage{
nc.copy.atts(f.src, v.src, f.dest, v.dest, exception.list = NULL,
  rename.mapping = NULL, definemode = FALSE)
}
\arguments{
  \item{f.src}{The source file (an object of class
  \code{ncdf4})}

  \item{v.src}{The source variable: a string naming a
  variable in a file or an object of class \code{ncvar4}.}

  \item{f.dest}{The destination file (an object of class
  \code{ncdf4})}

  \item{v.dest}{The destination variable: a string naming a
  variable in a file or an object of class \code{ncvar4}.}

  \item{exception.list}{A vector containing names of
  variables not to be copied.}

  \item{rename.mapping}{A vector containing named values
  mapping source to destination names.}

  \item{definemode}{Whether the file is already in define
  mode.}
}
\description{
Copy attributes from one variable in one file to another
file.
}
\details{
This function copies attributes from a variable in one file
to a variable in another file. If the source or destination
variable is 0, then attributes are copied from/to the
NetCDF file's global attributes.

If desired, some attributes can be left out using
\code{exception.list}, a vector of names of attributes to
be excluded.

Attributes can also be renamed at the destination using
\code{rename.mapping}, a named vector of strings in which
the name of the attribute to be renamed is the name, and
the attribute's new name is the value.
}
\examples{
## Copy attributes from one variable to another; but don't copy units or
## standard_name, and copy long_name as old_long_name.
\dontrun{
f1 <- nc_open("pr.nc")
f2 <- nc_open("pr2.nc")
nc.copy.atts(f1, "pr", f2, "pr", c("units", "standard_name"),
             c(long_name="old_long_name"))
dim.axes <- nc.get.dim.axes.from.names(f, "pr")
nc_close(f1)
nc_close(f2)
}
}

