% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFDataset.R, R/CFObject.R
\name{names.CFDataset}
\alias{names.CFDataset}
\alias{groups}
\alias{groups.CFDataset}
\alias{dimnames}
\title{Names or dimension values of an CF object}
\usage{
\method{names}{CFDataset}(x)

groups(x)

\method{groups}{CFDataset}(x)
}
\arguments{
\item{x}{An \code{CFObject} whose axis names to retrieve. This could be
\code{CFDataset}, \code{CFVariable}, or a class descending from \code{CFAxis}.}
}
\value{
A vector as described in the Description section.
}
\description{
Retrieve the variable or dimension names of an \code{ncdfCF} object.
The \code{names()} function gives the names of the variables in the data set,
prepended with the path to the group if the resource uses groups.
The return value of the \code{dimnames()} function differs depending on the type
of object:
\itemize{
\item \code{CFDataset}, \code{CFVariable}: The dimnames are returned as a vector of the
names of the axes of the data set or variable, prepended with the path to the
group if the resource uses groups. Note that this differs markedly from the
\code{base::dimnames()} functionality.
\item \code{CFAxisNumeric}, \code{CFAxisLongitude}, \code{CFAxisLatitude}, \code{CFAxisVertical}: The
values of the elements along the axis as a numeric vector.
\item \code{CFAxisTime}: The values of the elements along the axis as a
character vector containing timestamps in ISO8601 format. This could be dates
or date-times if time information is available in the axis.
\item \code{CFAxisScalar}: The value of the scalar.
\item \code{CFAxisCharacter}: The values of the elements along the axis as
a character vector.
\item \code{CFAxisDiscrete}: The index values of the axis, from 1 to the
length of the axis.
}
}
\examples{
fn <- system.file("extdata",
  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20230101-20231231_vncdfCF.nc",
  package = "ncdfCF")
ds <- open_ncdf(fn)

# CFDataset
dimnames(ds)

# CFVariable
pr <- ds[["pr"]]
dimnames(pr)

# CFAxisNumeric
lon <- ds[["lon"]]
dimnames(lon)

# CFAxisTime
t <- ds[["time"]]
dimnames(t)
}
