% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_att.R
\name{nc_att}
\alias{nc_att}
\alias{nc_att}
\alias{nc_att.NetCDF}
\alias{nc_att}
\alias{nc_att.character}
\title{NetCDF attributes}
\usage{
nc_att(x, variable, attribute, ...)

\method{nc_att}{NetCDF}(x, variable, attribute, ...)

\method{nc_att}{character}(x, variable, attribute, ...)
}
\arguments{
\item{x}{or file handle}

\item{variable}{name or index (zero based) of variable}

\item{attribute}{name or index (zero based) of attribute}

\item{...}{ignored}
}
\value{
data frame of attribute
}
\description{
Variable attributes are number 0:(n-1). Global attributes are indexed
by -1 or the label "NC_GLOBAL".
}
\details{
\code{nc_inq} includes the number of global attributes
\code{nc_vars} includes the number of variable attributes
}
\examples{
f <- system.file("extdata", "S2008001.L3m_DAY_CHL_chlor_a_9km.nc", package = "ncmeta")
nc_att(f, 0, 0)
}
