% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{gic.ncpen}
\alias{gic.ncpen}
\title{Compute the GIC values for the selection of the regularization parameter lambda.}
\usage{
gic.ncpen(ncpen.fit, y.vec, x.mat, df.weight = log(length(y.vec)),
  verbose = TRUE)
}
\arguments{
\item{ncpen.fit}{Fitted \code{ncpen} model object.}

\item{y.vec}{the response vector.}

\item{x.mat}{the design matrix.}

\item{df.weight}{the weight factor for various information criteria. For example, AIC if \code{df.weight=2},
BIC if \code{df.weight=log(n)}. Default is BIC.}

\item{verbose}{(logical) whether to plot the GIC curve. Default is \code{verbose=TRUE}.}
}
\value{
The coefficients \code{\link{matrix}}.
  \item{opt.beta}{the optimal coefficients \code{\link{vector}} selected by GIC.}
  \item{lambda}{the sequence of lambda values in the \code{ncpen} object.}
  \item{gic}{the GIC values for all lambda values.}
  \item{opt.lambda}{the optimal lambda value.}
  \item{plot}{the GIC curve.}
}
\description{
This function provides the selection of the regularization parameter lambda based
on the generalized information criterion (GIC) including AIC and BIC.
It computes the GIC values at a grid of values for the regularization parameter lambda.
}
\examples{
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5, seed = 1234)
x.mat = s0$x.mat
y.vec = s0$y.vec

fit = ncpen(y.vec=y.vec, x.mat=x.mat, family="gaussian")
gic.ncpen(fit,y.vec,x.mat,verbose=TRUE)

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.

Kim, Y., Kwon, S. and Choi, H. (2012). Consistent Model Selection Criteria on High Dimensions. \emph{Journal of Machine Learning Research}, \bold{13}, 1037-1057.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
