% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.indvars.R
\name{neg.indvars}
\alias{neg.indvars}
\alias{print.neg.indvars}
\title{Negligible Effect Test for Variances of Independent Populations}
\usage{
neg.indvars(dv, iv, eps = 0.5, alpha = 0.05, na.rm = TRUE, data = NULL, ...)

\method{print}{neg.indvars}(x, ...)
}
\arguments{
\item{dv}{Outcome Variable}

\item{iv}{Independent Variable}

\item{eps}{Used to Establish the Equivalence Bound (Conservative: .25; Liberal: .50, according to Wellek, 2010)}

\item{alpha}{Nominal Type I Error Rate}

\item{na.rm}{Missing Data Treatment}

\item{data}{Dataset containing dv and iv}

\item{...}{Extra arguments}

\item{x}{object of class \code{neg.indvars}}
}
\value{
returns a \code{list} containing each analysis and their respective statistics
  and decision


}
\description{
This function allows researchers to test whether the difference
in the variances of independent populations is negligible, where
negligible represents the smallest meaningful effect size (MMES, where
in this case the effect is the difference in population variances)
}
\examples{
#Two Group Example
indvar<-rep(c("a","b"),c(10,12))
depvar<-rnorm(22)
d<-data.frame(indvar,depvar)
neg.indvars(depvar,indvar)
neg.indvars(dv=depvar,iv=indvar,eps=.25,data=d)
neg.indvars(dv=depvar,iv=indvar,eps=.5)

#Four Group Example
indvar<-rep(c("a","b","c","d"),c(10,12,15,13))
depvar<-rnorm(50)
d<-data.frame(indvar,depvar)
neg.indvars(dv=depvar,iv=indvar,eps=.25,data=d)
neg.indvars(dv=depvar,iv=indvar)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Constance Mara \email{Constance.Mara@cchmc.org}
}
