% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OTPtransitivity.R
\name{OTPtransitivity}
\alias{OTPtransitivity}
\title{Outgoing two-path mechanism}
\usage{
OTPtransitivity(X, actor)
}
\arguments{
\item{X}{Binary network; of class \code{matrix}.}

\item{actor}{A unit (actor; row/column number), which have an opportunity to change a link.}
}
\value{
A vector with the number of paths of length two between the actor and other units.
}
\description{
Calculates the network statistic according to the outgoing two path mechanism.
}
\examples{
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
OTPtransitivity(X, actor = 2)
}
\references{
Cugmas, M., & Žiberna, A. (2022). Approaches to blockmodeling dynamic networks: a Monte Carlo simulation study. Social Networks, in print.
}
\author{
Marjan Cugmas and Aleš Žiberna
}
