% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemsqar_procedures_table.R
\docType{data}
\name{nemsqar_procedures_table}
\alias{nemsqar_procedures_table}
\title{Synthetic eProcedures Data from the National Emergency Medical Services
Information System (NEMSIS)}
\format{
A tibble with 10,000 rows and 8 variables:
\describe{
\item{\verb{Incident Patient Care Report Number - PCR (eRecord.01)}}{(chr) Unique identifier for the patient care report.}
\item{\verb{Incident Date}}{(date) The date of the EMS incident.}
\item{\verb{Procedure Performed Date Time (eProcedures.01)}}{(dttm) The date and time the procedure was performed.}
\item{\verb{Procedure Performed Prior To EMS Care (eProcedures.02)}}{(chr) Indicates whether the procedure was performed before EMS arrival.}
\item{\verb{Procedure Performed Description And Code (eProcedures.03)}}{(chr) Description and code of the performed procedure.}
\item{\verb{Patient Attempted Procedure Descriptions And Codes List (eProcedures.03)}}{(chr) List of attempted procedures with descriptions and codes.}
\item{\verb{Procedure Number Of Attempts (eProcedures.05)}}{(dbl) Number of attempts made to perform the procedure.}
\item{\verb{Procedure Successful (eProcedures.06)}}{(chr) Indicates whether the procedure was successful.}
}
}
\usage{
nemsqar_procedures_table
}
\description{
This dataset provides synthetic procedure-related information from the
eProcedures section of the National Emergency Medical Services Information
System (NEMSIS). It contains example procedure details that can be used for
testing various functions within the \code{nemsqar} package. Users are encouraged
to test these functions with this dataset, but results should not be
interpreted as meaningful. Some outputs may be nonsensical, which is expected
since this data is only intended to demonstrate the expected structure of
input data.
}
\details{
The data in this table are entirely synthetic and intended solely
for testing purposes. These data do not represent real patients, incidents,
or outcomes and should not be used for research or operational
decision-making.
}
\examples{
data(nemsqar_procedures_table)
dplyr::glimpse(nemsqar_procedures_table)

}
\keyword{datasets}
