% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nestedRanksTest.R
\name{nestedRanksTest}
\alias{nestedRanksTest}
\alias{nestedRanksTest.default}
\alias{nestedRanksTest.formula}
\title{Mann-Whitney-Wilcoxon ranks test when data are in groups.}
\usage{
\method{nestedRanksTest}{formula}(formula, data, groups = NULL, subset, ...)

\method{nestedRanksTest}{default}(x, y, groups, n.iter = 10000,
  lightweight = FALSE, ...)
}
\arguments{
\item{formula}{A formula of the form \code{lhs ~ rhs} or
\code{lhs ~ rhs | groups}, where \code{lhs}
is a numeric variable giving the data values, \code{rhs}
is a variable obeying conditions for \code{x}, and
\code{groups} is a variable obeying conditions for
\code{groups}.  If \code{"| groups"} is not included
in the formula, group membership must be specified with
the \code{groups} argument.}

\item{data}{An optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken
from \code{environment(formula)}.}

\item{groups}{A (non-empty) vector specifying group membership for each
\code{y}, coerced to a factor.  There must be at least one
\code{y} in each group for each treatment level.}

\item{subset}{An optional vector specifying a subset of observations to
be used.}

\item{...}{Further arguments to be passed to or from methods.}

\item{x}{A (non-empty) vector of treatments for each \code{y},
coerced to factor.  Must contain exactly two levels.}

\item{y}{A (non-empty) numeric vector of data values.}

\item{n.iter}{Number of bootstrap iterations to perform.  The value of
the final iteration is provided by the observed Z-score.
Using \code{n.iter = 1} simply returns the observed Z-score.}

\item{lightweight}{If \code{TRUE}, the vector of individual values of
the null distribution is excluded from the return value of
class \code{'htest_boot'}.  By default the null distribution
is included. If \code{n.iter} is large, specifying
\code{TRUE} for this option can save space, but note that
calling \code{plot} on the return value will produce an
error if so.}
}
\value{
A list with class \code{'htest_boot'} based on class
        \code{'htest'} containing the following components.  Components
        marked with \code{"*"} are additions to \code{'htest'}.
\tabular{ll}{
    \code{statistic}           \tab the value of the observed Z-score.\cr
    \code{p.value}             \tab the p-value for the test.\cr
    \code{alternative}         \tab a character string describing the
                                    alternative hypothesis.\cr
    \code{method}              \tab a character string indicating the nested
                                    ranks test performed.\cr
    \code{data.name}           \tab a character string giving the name(s) of
                                    the data.\cr
    \code{bad.obs}             \tab the number of observations in the data
                                    excluded because of \code{NA} values.\cr
    \code{null.values}         \tab quantiles of the null distribution used
                                    for calculating the p-value.\cr
    \code{n.iter*}             \tab the number of bootstrap iterations used
                                    for generating the null distribution.\cr
    \code{weights*}            \tab the weights for groups, calculated by
                                    \code{nestedRanksTest_weights}.\cr
    \code{null.distribution*}  \tab null distribution of Z-scores, with
                                    \code{statistic} the last value.\cr
}
The length of \code{null.distribution} equals \code{n.iter}.  Note that
\code{null.distribution} will not be present if the
\code{lightweight = TRUE} option was given to \code{nestedRanksTest}.
}
\description{
The statistic for the nested ranks test is a Z-score calculated by
comparing ranks between treatment levels, with contributions of each group
to the final Z-score weighted by group size.  The p-value is determined by
comparing the observed Z-score against a distribution of Z-scores
calculated by bootstrapping ranks assuming no influence of treatment while
respecting group sizes. When there is just one group, this test is
essentially identical to a standard Mann-Whitney-Wilcoxon test.  This test
is intended to be a mixed-model extension of the \code{\link{wilcox.test}},
for which treatment is a fixed effect and group membership is a random
effect.
}
\note{
Cases for which any of \code{x}, \code{y} or \code{groups} are
      \code{NA} are removed.

The generation of a null distribution can take some time.  For
      example, if any use of \code{nestedRanksTest} in the examples were
      run with the default \code{n.iter = 10000}, completion would require
      a few seconds.
}
\examples{
require(graphics)

data(woodpecker_multiyear)

## S3 method for class 'formula'

## n.iter set to 1000 to shorten completion time

## group in formula
nestedRanksTest(Distance ~ Year | Granary, n.iter = 1000,
                data = woodpecker_multiyear,
                subset = Species == "agrifolia")
## group in 'groups='
nestedRanksTest(Distance ~ Year, groups = Granary, n.iter = 1000,
                data = woodpecker_multiyear,
                subset = Species == "lobata")

## Default S3 method

dat.a <- subset(woodpecker_multiyear, Species == "agrifolia")
## arguments in default order
nestedRanksTest(dat.a$Year, dat.a$Distance, dat.a$Granary, n.iter = 1000)
## named arguments used in 'formula' order
res <- with(subset(woodpecker_multiyear, Species == "lobata"),
           nestedRanksTest(y = Distance, x = Year, groups = Granary,
                           n.iter = 1000))
plot(res)
}
\references{
Thompson, P. G., Smouse, P. E., Scofield, D. G. and Sork, V. L. (2014)
What seeds tell us about birds: a multi-year analysis of acorn woodpecker
foraging movements.  \emph{Movement Ecology} 2:12.
\url{http://www.movementecologyjournal.com/content/2/1/12}

\url{https://github.com/douglasgscofield/nestedRanksTest}
}
\seealso{
\code{\link{wilcox.test}}, \code{\link{print.htest_boot}},
         \code{\link{plot.htest_boot}}
}
\keyword{htest}
\keyword{nonparametric}

