% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatcv.R
\name{repeatcv}
\alias{repeatcv}
\title{Repeated nested CV}
\usage{
repeatcv(expr, n = 5, repeat_folds = NULL, keep = FALSE, progress = TRUE)
}
\arguments{
\item{expr}{An expression containing a call to \code{\link[=nestcv.glmnet]{nestcv.glmnet()}},
\code{\link[=nestcv.train]{nestcv.train()}}, \code{\link[=nestcv.SuperLearner]{nestcv.SuperLearner()}} or \code{\link[=outercv]{outercv()}}.}

\item{n}{Number of repeats}

\item{repeat_folds}{Optional list containing fold indices to be applied to
the outer CV folds.}

\item{keep}{Logical whether to save repeated outer CV predictions for ROC
curves etc.}

\item{progress}{Logical whether to show progress.}
}
\value{
List of S3 class 'repeatcv' containing the model call, matrix of
performance metrics, and if \code{keep = TRUE} a matrix or dataframe containing
the outer CV predictions from each repeat.
}
\description{
Performs repeated calls to a \code{nestedcv} model to determine performance across
repeated runs of nested CV.
}
\details{
When comparing models, it is recommended to fix the sets of outer CV folds
used across each repeat for comparing performance between models. The
function \code{\link[=repeatfolds]{repeatfolds()}} can be used to create a fixed set of outer CV folds
for each repeat.
}
\examples{
\donttest{
data("iris")
dat <- iris
y <- dat$Species
x <- dat[, 1:4]

res <- repeatcv(n = 3, nestcv.glmnet(y, x,
                                     family = "multinomial", alphaSet = 1,
                                     n_outer_folds = 4, cv.cores = 2))
res
summary(res)

## using magrittr nested pipe
`\%|>\%` <- magrittr::pipe_nested
res <- nestcv.glmnet(y, x, family = "multinomial", alphaSet = 1,
                     n_outer_folds = 4, cv.cores = 2) \%|>\%
       repeatcv(3)
res

## set up fixed fold indices
set.seed(123, "L'Ecuyer-CMRG")
folds <- repeatfolds(y, repeats = 3, n_outer_folds = 4)
res <- nestcv.glmnet(y, x, family = "multinomial", alphaSet = 1,
                     n_outer_folds = 4, cv.cores = 2) \%|>\%
       repeatcv(3, repeat_folds = folds)
res
}
}
