% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cva.glmnet.R
\name{cva.glmnet}
\alias{cva.glmnet}
\title{Cross-validation of alpha for glmnet}
\usage{
cva.glmnet(x, y, nfolds = 10, alphaSet = seq(0.1, 1, 0.1), foldid = NULL, ...)
}
\arguments{
\item{x}{Matrix of predictors}

\item{y}{Response vector}

\item{nfolds}{Number of folds (default 10)}

\item{alphaSet}{Sequence of alpha values to cross-validate}

\item{foldid}{Optional vector of values between 1 and \code{nfolds} identifying
what fold each observation is in.}

\item{...}{Other arguments passed to \link{cv.glmnet}}
}
\value{
Object of S3 class "cva.glmnet", which is a list of the cv.glmnet
objects for each value of alpha and \code{alphaSet}.
\item{fits}{List of fitted \link{cv.glmnet} objects}
\item{alphaSet}{Sequence of alpha values used}
\item{alpha_cvm}{The mean cross-validated error - a vector of length
\code{length(alphaSet)}.}
\item{best_alpha}{Value of alpha giving lowest \code{alpha_cvm}.}
\item{which_alpha}{Index of \code{alphaSet} with lowest \code{alpha_cvm}}
}
\description{
Performs k-fold cross-validation for glmnet, including alpha mixing parameter.
}
\seealso{
\link{cv.glmnet}, \link{glmnet}
}
\author{
Myles Lewis
}
