% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested.R
\name{nested}
\alias{nested}
\alias{is_nested}
\alias{nested.default}
\alias{nested.model_spec}
\alias{nested.nested_model}
\alias{nested.workflow}
\alias{is_nested.default}
\alias{is_nested.model_spec}
\alias{is_nested.workflow}
\title{Create a Nested Model}
\usage{
nested(x, ...)

is_nested(x, ...)

\method{nested}{default}(x, ...)

\method{nested}{model_spec}(x, ...)

\method{nested}{nested_model}(x, ...)

\method{nested}{workflow}(x, ...)

\method{is_nested}{default}(x, ...)

\method{is_nested}{model_spec}(x, ...)

\method{is_nested}{workflow}(x, ...)
}
\arguments{
\item{x}{A model specification or workflow.}

\item{...}{Not currently used.}
}
\value{
A nested model object, or a workflow containing a nested model.
For \code{is_nested()}, a logical vector of length 1.
}
\description{
\code{nested()} turns a model or workflow into a nested model/workflow.
\code{is_nested()} checks if a model or workflow is nested.
}
\examples{
model <- parsnip::linear_reg() \%>\%
  parsnip::set_engine("lm") \%>\%
  nested()

model

is_nested(model)

wf <- workflows::workflow() \%>\%
  workflows::add_model(model)

is_nested(wf)

}
