% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{create.folds}
\alias{create.folds}
\title{Cross-validation folds}
\usage{
create.folds(num.folds, num.rows, seed = NULL)
}
\arguments{
\item{num.folds}{Number of folds to be created.}

\item{num.rows}{Number of observations in the dataset.}

\item{seed}{Seed of the random number generator. If \code{NULL}, the folds
generated will be different at each invocation; for reproducibility
of results, it is recommended to set this to a specific value.}
}
\value{
A list of length \code{num.folds} containing the indices of the observations
to be withdrawn for validation in each fold.
}
\description{
Create a list of indices corresponding to cross-validation folds.
}
\note{
Note that the number of observations withdrawn in each fold may not be
exactly the same if \code{num.folds} is not an integer divisor of
\code{num.rows}.
}
\examples{
all.folds <- create.folds(50, 307, 0)
}
