# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

toa_mat_cpp <- function(year, t0, t1) {
    .Call('netdiffuseR_toa_mat_cpp', PACKAGE = 'netdiffuseR', year, t0, t1)
}

edgelist_to_adjmat_cpp <- function(edgelist, weights = as.numeric( c()), n = 0L, undirected = FALSE, self = FALSE, multiple = FALSE) {
    .Call('netdiffuseR_edgelist_to_adjmat_cpp', PACKAGE = 'netdiffuseR', edgelist, weights, n, undirected, self, multiple)
}

adjmat_to_edgelist_cpp <- function(adjmat, undirected = TRUE) {
    .Call('netdiffuseR_adjmat_to_edgelist_cpp', PACKAGE = 'netdiffuseR', adjmat, undirected)
}

toa_diff_cpp <- function(year) {
    .Call('netdiffuseR_toa_diff_cpp', PACKAGE = 'netdiffuseR', year)
}

isolated_cpp <- function(adjmat, undirected = TRUE) {
    .Call('netdiffuseR_isolated_cpp', PACKAGE = 'netdiffuseR', adjmat, undirected)
}

drop_isolated_cpp <- function(adjmat, isolated, undirected = TRUE) {
    .Call('netdiffuseR_drop_isolated_cpp', PACKAGE = 'netdiffuseR', adjmat, isolated, undirected)
}

egonet_attrs_cpp <- function(graph, V, attrs, outer = TRUE, self = TRUE, valued = TRUE) {
    .Call('netdiffuseR_egonet_attrs_cpp', PACKAGE = 'netdiffuseR', graph, V, attrs, outer, self, valued)
}

infection_cpp <- function(graph, times, normalize = TRUE, K = 1L, r = 0.5, expdiscount = FALSE, n = 0L, T = 0L, valued = FALSE) {
    .Call('netdiffuseR_infection_cpp', PACKAGE = 'netdiffuseR', graph, times, normalize, K, r, expdiscount, n, T, valued)
}

susceptibility_cpp <- function(graph, times, normalize = TRUE, K = 1L, r = 0.5, expdiscount = FALSE, n = 0L, T = 0L, valued = FALSE) {
    .Call('netdiffuseR_susceptibility_cpp', PACKAGE = 'netdiffuseR', graph, times, normalize, K, r, expdiscount, n, T, valued)
}

moran_cpp <- function(x, w) {
    .Call('netdiffuseR_moran_cpp', PACKAGE = 'netdiffuseR', x, w)
}

#' Distribution over a grid
#'
#' Distribution of pairs over a grid of fix size.
#'
#' @param x Numeric vector of size \eqn{n}
#' @param y Numeric vector of size \eqn{n}
#' @param nlevels Integer scalar. Number of bins to return
#' @details
#'
#' This function ment for internal use only.
#'
#' @export
#' @keywords misc dplot
#' @seealso Used by \code{\link{plot_infectsuscep}}
#' @return Returns a list with three elements
#' \item{x}{Numeric vector of size \code{nlevels} with the class marks for x}
#' \item{y}{Numeric vector of size \code{nlevels} with the class marks for y}
#' \item{z}{Numeric matrix of size \code{nlevels} by \code{nlevels} with the distribution %
#' of the elements in terms of frecuency}
#' @section Examples:
#' \preformatted{
#' # Generating random vectors of size 100
#' x <- rnorm(100)
#' y <- rnorm(100)
#'
#' # Calculating distribution
#' grid_distribution(x,y,20)
#' }
grid_distribution <- function(x, y, nlevels = 100L) {
    .Call('netdiffuseR_grid_distribution', PACKAGE = 'netdiffuseR', x, y, nlevels)
}

#' Compute ego/alter edge coordinates considering alter's size and aspect ratio
#'
#' Given a graph, vertices' positions and sizes, calculates the absolute positions
#' of the endpoints of the edges considering the plot's aspect ratio.
#'
#' @param graph A square matrix of size \eqn{n}. Adjacency matrix.
#' @param toa Integer vector of size \eqn{n}. Times of adoption.
#' @param x Numeric vector of size \eqn{n}. x-coordinta of vertices.
#' @param y Numeric vector of size \eqn{n}. y-coordinta of vertices.
#' @param vertex_cex Numeric vector of size \eqn{n}. Vertices' sizes in terms
#' of the x-axis (see \code{\link{symbols}}).
#' @param undirected Logical scalar. Whether the graph is undirected or not.
#' @param no_contemporary Logical scalar. Whether to return (calcular) edges'
#' coordiantes for vertices with the same time of adoption (see details).
#' @return A numeric matrix of size \eqn{m\times 8}{m * 8} with the following
#' columns:
#' \item{x0, y0}{Edge origin}
#' \item{x1, y1}{Edge target}
#' \item{size0, size1}{Size of the vertices of ego and alter in terms of the x-axis}
#' \item{alpha}{Relative angle between \code{(x0,y0)} and \code{(x1,y1)} in terms
#' of radians}
#' \item{dist}{Relavtide distance between ego and alters' center.}
#' With \eqn{m} as the number of resulting edges.
#' @details
#'
#' In order to make the plot's visualization more appealing, this function provides
#' a straight forward way of computing the tips of the edges considering the
#' aspect ratio of the axes range. In particular, the following corrections are
#' made at the moment of calculating the egdes coords:
#'
#' \itemize{
#' \item{Instead of using the actual distance between ego and alter, a relative
#' one is calculated as follows
#' \deqn{d'=\left[(x_0-x_1)^2 + (y_0' - y_1')^2\right]^\frac{1}{2}}{d'=sqrt[(x0-x1)^2 + (y0'-y1')^2]}
#' where \eqn{%
#' y_i'=y_i\times\frac{\max x - \min x}{\max y - \min y} }{%
#' yi' = yi * [max(x) - min(x)]/[max(y) - min(y)]}
#' }
#' \item{Then, for the relative elevation angle, \code{alpha}, the relative distance \eqn{d'}
#' is used, \eqn{\alpha'=\arccos\left( (x_0 - x_1)/d' \right)}{\alpha' = acos[ (x0 - x1)/d' ]}}
#' \item{Finally, the edge's endpoint's (alter) coordinates are computed as follows: %
#' \deqn{%
#'   x_1' = x_1 + \cos(\alpha')\times v_1}{%
#'   x1' = x1 + cos(\alpha') * v1
#' }
#' \deqn{%
#'   y_1' = y_1 -+ \sin(\alpha')\times v_1 \times\frac{\max y - \min y}{\max x - \min x} }{%
#'   y1' = y1 -+ sin(\alpha')*[max(y) - min(y)]/[max(x) - min(x)]
#' }
#' Where \eqn{v_1}{v1} is alter's size in terms of the x-axis, and the sign of
#' the second term in \eqn{y_1'}{y1'} is negative iff \eqn{y_0 < y_1}{y0<y1}.
#' }
#' }
#'
#' The resulting values, \eqn{x_1',y_1'}{x1',y1'} can be used with the function
#' \code{\link{arrows}}. This is the workhorse function used in \code{\link{plot_threshold}}.
#' @keywords misc dplot
#' @export
edges_coords <- function(graph, toa, x, y, vertex_cex, undirected = TRUE, no_contemporary = TRUE) {
    .Call('netdiffuseR_edges_coords', PACKAGE = 'netdiffuseR', graph, toa, x, y, vertex_cex, undirected, no_contemporary)
}

rgraph_ba_cpp <- function(graph, dgr, m = 1L, t = 10L) {
    .Call('netdiffuseR_rgraph_ba_cpp', PACKAGE = 'netdiffuseR', graph, dgr, m, t)
}

rgraph_ba_new_cpp <- function(m0 = 1L, m = 1L, t = 10L) {
    .Call('netdiffuseR_rgraph_ba_new_cpp', PACKAGE = 'netdiffuseR', m0, m, t)
}

rgraph_er_cpp <- function(n = 10L, p = 0.3, undirected = TRUE, weighted = FALSE, self = FALSE) {
    .Call('netdiffuseR_rgraph_er_cpp', PACKAGE = 'netdiffuseR', n, p, undirected, weighted, self)
}

rgraph_er_dyn_cpp <- function(n = 10L, t = 3L, p = 0.3, undirected = TRUE, weighted = FALSE, self = FALSE) {
    .Call('netdiffuseR_rgraph_er_dyn_cpp', PACKAGE = 'netdiffuseR', n, t, p, undirected, weighted, self)
}

#' Ring lattice graph
#'
#' Creates a ring lattice with \eqn{n} vertices, each one of degree (at most) \eqn{k}
#' as an undirected graph. This is the basis of \code{\link{rgraph_ws}}.
#' @param n Integer scalar. Size of the graph.
#' @param k Integer scalar. Degree of each vertex.
#' @details Since the created graph is undirected, the degree of each node always
#' even. So if \code{k=3}, then the degree will be \code{2}.
#' @return A sparse matrix of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} of size
#' \eqn{n\times n}{n * n}.
#' @references Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of
#' “small-world” networks. Nature, 393(6684), 440–2. \url{http://doi.org/10.1038/30918}
#' @export
ring_lattice <- function(n, k) {
    .Call('netdiffuseR_ring_lattice', PACKAGE = 'netdiffuseR', n, k)
}

rewire_graph_cpp <- function(graph, p, both_ends = FALSE, self = FALSE, multiple = FALSE, undirected = FALSE) {
    .Call('netdiffuseR_rewire_graph_cpp', PACKAGE = 'netdiffuseR', graph, p, both_ends, self, multiple, undirected)
}

select_egoalter_cpp <- function(adjmat_t0, adjmat_t1, adopt_t0, adopt_t1) {
    .Call('netdiffuseR_select_egoalter_cpp', PACKAGE = 'netdiffuseR', adjmat_t0, adjmat_t1, adopt_t0, adopt_t1)
}

degree_cpp <- function(adjmat0, cmode = 2L, undirected = TRUE, self = FALSE, valued = FALSE) {
    .Call('netdiffuseR_degree_cpp', PACKAGE = 'netdiffuseR', adjmat0, cmode, undirected, self, valued)
}

exposure_cpp <- function(graph, cumadopt, attrs, outgoing = TRUE, valued = TRUE, normalized = TRUE) {
    .Call('netdiffuseR_exposure_cpp', PACKAGE = 'netdiffuseR', graph, cumadopt, attrs, outgoing, valued, normalized)
}

cumulative_adopt_count_cpp <- function(cumadopt) {
    .Call('netdiffuseR_cumulative_adopt_count_cpp', PACKAGE = 'netdiffuseR', cumadopt)
}

hazard_rate_cpp <- function(cumadopt) {
    .Call('netdiffuseR_hazard_rate_cpp', PACKAGE = 'netdiffuseR', cumadopt)
}

threshold_cpp <- function(exposure, toa) {
    .Call('netdiffuseR_threshold_cpp', PACKAGE = 'netdiffuseR', exposure, toa)
}

struct_equiv_cpp <- function(graph, v = 1.0, unscaled = FALSE, inv = FALSE, invrep = 0.0) {
    .Call('netdiffuseR_struct_equiv_cpp', PACKAGE = 'netdiffuseR', graph, v, unscaled, inv, invrep)
}

