% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graph.R
\name{rgraph_ws}
\alias{rgraph_ws}
\alias{small-world}
\title{Watts-Strogatz model}
\usage{
rgraph_ws(n, k, p, both.ends = FALSE, self = FALSE, multiple = FALSE)
}
\arguments{
\item{n}{Integer scalar. Set the size of the graph.}

\item{k}{Integer scalar. Set the initial degree of the ring (must be less than \eqn{n}).}

\item{p}{Numeric scalar. Set the probability of changing an edge.}

\item{both.ends}{Logical scalar. When \code{TRUE} rewires both ends.}

\item{self}{Logical scalar. When \code{TRUE}, allows loops (self edges).}

\item{multiple}{Logical scalar. When \code{TRUE} allows multiple edges.}
}
\value{
A random graph of size \eqn{n\times n}{n*n} following the small-world
model. The resulting graph will have \code{attr(graph, "undirected")=FALSE}.
}
\description{
Generates a small-world random graph.
}
\author{
Vega Yon
}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of "small-world"
networks. Nature, 393(6684), 440–2. \url{http://dx.doi.org/10.1038/30918}

Newman, M. E. J. (2003). The Structure and Function of Complex Networks.
SIAM Review, 45(2), 167–256. \url{http://doi.org/10.1137/S003614450342480}
}
\seealso{
Other simulation functions: \code{\link{rdiffnet}},
  \code{\link{rewire_graph}}, \code{\link{rgraph_ba}},
  \code{\link{rgraph_er}}
}

