% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{summary.diffnet}
\alias{summary.diffnet}
\title{Summary of diffnet objects}
\usage{
\method{summary}{diffnet}(object, slices = NULL, no.print = FALSE,
  skip.moran = FALSE, valued = getOption("diffnet.valued", FALSE), ...)
}
\arguments{
\item{object}{An object of class \code{\link[=as_diffnet]{diffnet}}.}

\item{slices}{Either an integer or character vector. While integer vectors are used as
indexes, character vectors are used jointly with the time period labels.}

\item{no.print}{Logical scalar. When TRUE suppress screen messages.}

\item{skip.moran}{Logical scalar. When TRUE Moran's I is not reported (see details).}

\item{valued}{Logical scalar. When \code{TRUE} weights will be considered.
Otherwise non-zero values will be replaced by ones.}

\item{...}{Further arguments to be passed to \code{\link{approx_geodesic}}.}
}
\value{
A data frame with the following columns:
\item{adopt}{Integer. Number of adopters at each time point.}
\item{cum_adopt}{Integer. Number of cumulative adopters at each time point.}
\item{cum_adopt_pcent}{Numeric. Proportion of comulative adopters at each time point.}
\item{hazard}{Numeric. Hazard rate at each time point.}
\item{density}{Numeric. Density of the network at each time point.}
\item{moran_obs}{Numeric. Observed Moran's I.}
\item{moran_exp}{Numeric. Expected Moran's I.}
\item{moran_sd}{Numeric. Standard error of Moran's I under the null.}
\item{moran_pval}{Numeric. P-value for the observed Moran's I.}
}
\description{
Summary of diffnet objects
}
\details{
Moran's I is calculated over the
cumulative adoption matrix using as weighting matrix the inverse of the geodesic
distance matrix. All this via \code{\link{moran}}. For each time period \code{t},
this is calculated as:

\preformatted{
 m = moran(C[,t], G^(-1))
}

Where \code{C[,t]} is the t-th column of the cumulative adoption matrix,
\code{G^(-1)} is the element-wise inverse of the geodesic matrix at time \code{t},
and \code{moran} is \pkg{netdiffuseR}'s moran's I routine. When \code{skip.moran=TRUE}
Moran's I is not reported. This can be useful for both: reducing computing
time and saving memory as geodesic distance matrix can become large. Since
version \code{1.18.0}, geodesic matrices are approximated using \code{approx_geodesic}
which, as a difference from \code{\link[sna:geodist]{geodist}} from the
\pkg{sna} package, and \code{\link[igraph:distances]{distances}} from the
\pkg{igraph} package returns a matrix of class \code{dgCMatrix} (more
details in \code{\link{approx_geodesic}}).
}
\examples{
data(medInnovationsDiffNet)
summary(medInnovationsDiffNet)

}
\seealso{
Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as.array.diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet-class}}, \code{\link{diffnet_index}},
  \code{\link{plot.diffnet}}
}
\author{
George G. Vega Yon
}
\concept{diffnet methods}
