% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeNetwork.R
\name{makeNetwork}
\alias{makeNetwork}
\title{Generate network based on coordinates.}
\usage{
makeNetwork(coordinates, distance.matrix = NULL, name = NULL,
  comment = NULL, membership = NULL, edge.weight.type = NULL,
  depot.coordinates = NULL, lower = NULL, upper = NULL,
  opt.tour.length = NULL, opt.tour = NULL, node.weights = NULL)
}
\arguments{
\item{coordinates}{[\code{matrix}]\cr
Numeric matrix of 2D coordinates.}

\item{distance.matrix}{[\code{matrix}]\cr
Optional distance matrix.}

\item{name}{[\code{character(1)} | \code{NULL}]\cr
Optional name of the network.}

\item{comment}{[\code{character} | \code{NULL}]\cr
Optional additional comments on instance.}

\item{membership}{[\code{numeric} | \code{NULL}]\cr
Optional vector of memberships for clustered networks.}

\item{edge.weight.type}{[\code{character(1)} | \code{NULL}]
The edge weight type indicates how edge weights are represented in the TSPlib
format. If \code{distance.matrix} is \code{NULL}, the passed value is ignored
and EUC\_2D is assigned. Otherwise the edge weight type must be one of the
following \code{{EUC\_2D, EUC\_3D, MAX\_2D, MAX\_3D, MAN\_2D, MAN\_3D, CEIL\_2D,
GEO, ATT, EXPLICIT}}.}

\item{depot.coordinates}{[\code{matrix} | \code{NULL}]\cr
Numeric matrix of 2D coordinates of depots. Default is \code{NULL}, which
means no depots at all.}

\item{lower}{[\code{numeric(1)}]\cr
Lower box constraint of cube.}

\item{upper}{[\code{numeric(1)}]\cr
Upper box constraint of cube.}

\item{opt.tour.length}{[\code{numeric(1)}]\cr
Optional length of the optimal roundtrip tour.
Default is \code{NULL}, which means the tour length is unknown.}

\item{opt.tour}{[\code{integer}]\cr
Optional optimal permutation of node indizes.
Default is \code{NULL}, which means the optimal tour is unknown.}

\item{node.weights}{[\code{numeric}]\cr
Vector of node weights (for weighted version of TSP). Default is \code{NULL},
i.e., no node weights at all.}
}
\value{
[\code{Network}]
}
\description{
Create a (clustered) network object.
}
