% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabias.netmeta.R
\name{metabias.netmeta}
\alias{metabias.netmeta}
\title{Test of funnel plot asymmetry in network meta-analysis}
\usage{
\method{metabias}{netmeta}(
  x,
  order,
  pooled = ifelse(x$random, "random", "common"),
  method.bias = "Egger",
  lump.comparator = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{order}{A mandatory character or numerical vector specifying
the order of treatments or list of comparators (see Details).}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model (\code{"random"})
should be used in test of funnel plot asymmetry. Can be
abbreviated.}

\item{method.bias}{A character vector indicating which test(s) for
funnel plot asymmatrx to use. Admissible values are
\code{"Begg"}, \code{"Egger"}, and \code{"Thompson"}, can be
abbreviated. See function \code{\link[meta]{metabias.meta}}.}

\item{lump.comparator}{A logical indicating whether comparators
should be lumped, e.g., to specify inactive treatments.
information on direct comparisons should be added to the plot.}

\item{\dots}{Additional arguments (passed on to
\code{\link[meta]{metabias.meta}}).}
}
\value{
A list with class \code{metabias} containing the following
components if a test for funnel plot asymmetry is conducted:
\item{statistic}{Test statistic.}
\item{df}{The degrees of freedom of the test statistic in
  the case that it follows a t distribution.}
\item{pval}{The p-value for the test.}
\item{estimate}{Estimates used to calculate test statisic.}
\item{method}{A character string indicating what type of test was
  used.}
\item{title}{Title of Cochrane review.}
\item{complab}{Comparison label.}
\item{outclab}{Outcome label.}
\item{var.model}{A character string indicating whether none,
  multiplicative, or additive residual heterogeneity variance was
  assumed.}
\item{method.bias}{As defined above.}
\item{x}{Network meta-analysis object.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
\item{version.netmeta}{Version of R package \bold{netmeta} used to
  create object.}

Or a list with the following elements if test is not conducted due
to the number of studies:
\item{k}{Number of comparisons.}
\item{k.min}{Minimum number of comparisons to perform test for
  funnel plot asymmetry.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
\item{version.netmeta}{Version of R package \bold{netmeta} used to
  create object.}
}
\description{
Test of funnel plot asymmetry in network meta-analysis
}
\details{
Test of funnel plot asymmetry in network meta-analysis

Argument \code{order} is mandatory to determine the order of
treatments (Chaimani et al., 2013):

\emph{\dQuote{[...] investigators should order
the treatments in a meaningful way and make assumptions about how
small studies differ from large ones. For example, if they
anticipate that newer treatments are favored in small trials, then
they could name the treatments from oldest to newest so that all
comparisons refer to \sQuote{old versus new intervention}. Other
possibilities include defining the comparisons so that all refer to
an active treatment versus placebo or sponsored versus
non-sponsored intervention.}}

Alternatively, it is possible to only provide a single or few
treatment name(s) in argument \code{order} to define the
comparator(s). In this case only comparisons with this / these
treatment(s) will be considered. If argument \code{lump.comparator}
is \code{TRUE}, all comparators will be lumped into a single
group.
}
\examples{
\dontrun{
data(Senn2013)

net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD")

# Test for asymmetry in 'comparison-adjusted' funnel plot not
# conducted as argument 'order' is missing
#
try(metabias(net1))

# Test for funnel plot asymmetry comparing active treatments with
# placebo
metabias(net1, order = "pl")

# Rank test
#
metabias(net1, order = "pl", method.bias = "Begg")


# Test for funnel plot asymmetry based on (non-sensical) alphabetic
# order of treatments with placebo as last treatment
#
ord <- c("a", "b", "me", "mi", "pi", "r", "si", "su", "v", "pl")
metabias(net1, order = ord)
}

}
\references{
Chaimani A & Salanti G (2012):
Using network meta-analysis to evaluate the existence of
small-study effects in a network of interventions.
\emph{Research Synthesis Methods},
\bold{3}, 161--76

Chaimani A, Higgins JP, Mavridis D, Spyridonos P, Salanti G (2013):
Graphical tools for network meta-analysis in STATA.
PLOS ONE,
\bold{8}, e76654
}
\seealso{
\code{\link{netmeta}}, \code{\link{funnel.netmeta}},
  \code{\link{metabias}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
