% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankogram.R
\name{rankogram}
\alias{rankogram}
\title{Generic function for rankograms}
\usage{
rankogram(x, ...)
}
\arguments{
\item{x}{An R object.}

\item{\dots}{Additional arguments.}
}
\description{
Generic function to calculate the probabilities of each treatment being
at each possible rank and the SUCRAs (Surface Under the Cumulative
RAnking curve) in network meta-analysis.
}
\details{
For more details, look at the following functions to generate
rankograms:
\itemize{
\item \code{\link{rankogram.netmeta}}
\item \code{\link{rankogram.default}}
}
}
\examples{
pw1 <- pairwise(treatment, event = r, n = N, studlab = author,
  data = dat.woods2010, sm = "OR")
net1 <- netmeta(pw1, small.values = "desirable")

set.seed(1909) # get reproducible results
ran1 <- rankogram(net1, nsim = 100)
ran1
print(ran1, cumulative.rankprob = TRUE)

plot(ran1)

}
\references{
Salanti G, Ades AE, Ioannidis JP (2011):
Graphical methods and numerical summaries for presenting results
from multiple-treatment meta-analysis: an overview and tutorial.
\emph{Journal of Clinical Epidemiology},
\bold{64}, 163--71
}
\seealso{
\code{\link{netmeta}}, \code{\link{netrank}},
  \code{\link{plot.rankogram}}, \code{\link[metadat]{dat.woods2010}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
