% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei.R
\name{ei}
\alias{ei}
\alias{ei.table}
\alias{ei.igraph}
\alias{ei.default}
\title{Krackhard and Stern's E-I index}
\usage{
ei(object, ...)

\method{ei}{table}(object, ...)

\method{ei}{igraph}(
  object,
  vattr,
  directed = is.directed(object),
  loops = any(is.loop(object)),
  ...
)

\method{ei}{default}(object, ...)
}
\arguments{
\item{object}{R object, see Details for available methods}

\item{...}{other arguments passed to/from other methods}

\item{vattr}{character scalar or vector of length equal to the size of
\code{object}, vertex attribute for which mixing matrix is to be computed}

\item{directed}{logical whether the network is directed}

\item{loops}{logical, whether loops are allowed}
}
\value{
Numerical value of the E-I index.
}
\description{
An index proposed by Krackhard and Stern (1988) to capture relative
prevalence of between- and within-group ties. From that perspective it can
be interpreted as a measure of network segregation.
}
\details{
If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.
}
\examples{
ei(WhiteKinship, "gender")
}
\references{
Krackhardt, D., & Stern, R. N. (1988). Informal networks and
organizational crises: An experimental simulation. \emph{Social Psychology
Quarterly}, 123-140.
}
\seealso{
Other segregation measures: 
\code{\link{assort}()},
\code{\link{coleman}()},
\code{\link{freeman}()},
\code{\link{gamix}()},
\code{\link{orwg}()},
\code{\link{smi}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
