\name{permTest}
\alias{permTest}
\alias{permScores}
\title{
  Calculate Cluster Permutation \emph{p}-Values and Scores
}
\description{
  \code{permScores} calculates the cluster scores for permuted data and 
  \code{permTest} calculates the permutation \emph{p}-values for the clusters. 
}
\usage{
permScores(perm_prot, prot_data, clust_2_protein, 
           cscoremethod = "mean")
permTest(B, prot_data, clust_2_protein, cluster_scores, 
         cscoremethod = "mean")
}
\arguments{
  \item{B}{
    Integer specifying the number of permutations to run.
  }
  \item{prot_data}{
    Data frame of protein information (protein ID, \emph{p}-value, weight, measure) generated by \code{\link{measureCalc}}.
  }
  \item{clust_2_protein}{
    Data frame of cluster information (cluster ID, size, cluster members) generated by \code{\link{findDenseClusters}}.
  }
  \item{cluster_scores}{
    Numeric vector generated by \code{\link{scoreClusters}}; permutation values are compared to these values to
    determine the cluster \emph{p}-value. 
  }
  \item{cscoremethod}{
    Function (mean or median) for calculating cluster scores.
  }
  \item{perm_prot}{
    Character vector of (permuted) protein IDs.
  }
}
\details{
The function \code{permTest} is used in the NetWeAvers algorithm (\code{\link{runNetweavers}}) when the permutation test argument is TRUE. 
It permutes protein IDs, calls \code{permScores} to calculate cluster scores to create a null distribution, and then calcluates
a permutation \emph{p}-value equal to the proportion of permuted scores more extreme than that of the original. 
}
\value{
  \code{permScores} returns a numeric vector of cluster scores.
  
  \code{permTest} returns a numeric vector of \emph{p}-values.
}
\seealso{
\code{\link{scoreClusters}}, \code{\link{runNetweavers}}
}
\examples{
\dontrun{
data(vanHoof)
cluster_scoresVH <- scoreClusters(clust_2_proteinVH, 
                                  proteinInfoVH[,c('Protein','measure')], 
                                  "mean")
permTest(10, proteinInfoVH, clust_2_proteinVH, cluster_scoresVH, "mean")
}
}
\keyword{ methods }
