\name{scoreClusters}
\alias{scoreClusters}
\title{
Calculate Total Cluster Score for All Clusters
}
\description{
  Calculates a score for each cluster as a part of the NetWeAvers algorithm.
}
\usage{
scoreClusters(clust_2_protein, prot_meas, cscoremethod = "mean")
}
\arguments{
  \item{clust_2_protein}{
    Data frame of cluster information containing the following:
      \enumerate{
      \item{\code{clusID}}{  Factor or character vector; cluster IDs.}
      \item{\code{clusSIZE}}{Numeric vector of integers containing the size (number of proteins) in each cluster.}
      \item{\code{X1 }}{      Character vector of proteins; the first protein for each cluster.}
      \item{\code{...}}{     Additional cluster symbols, as many as \code{clusSIZE} dictates per cluster.}
      }
  }
  \item{prot_meas}{
    Data frame, as generated by \code{\link{measureCalc}}, on the following 2 variables:
    \describe{
      \item{\code{Protein}}{Factor or vector of protein identifiers.}
      \item{\code{measure}}{Numeric vector of protein measures.}
    }
  }
  \item{cscoremethod}{
    Function (mean or median) for calculating cluster scores.
  }
}
\details{
This function applies the specified \code{cscoremethod} (mean or median) to the protein measures within a given cluster. 
The protein identifiers in \code{clust_2_protein} and \code{measure} should match.
}
\value{
  Numeric vector of cluster scores.
}
\seealso{
\code{\link{measureCalc}}, \code{\link{runNetweavers}}
}
\examples{
data(vanHoof)
scoreClusters(clust_2_proteinVH, proteinInfoVH[,c('Protein','measure')], 
              "mean")
}
\keyword{ methods }