% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact_NCT.R
\name{impact.NCT}
\alias{impact.NCT}
\title{Network Comparison Test for Impact Statistics}
\usage{
impact.NCT(input, it, gamma, nodes = c("all"), binary.data = FALSE,
  weighted = TRUE, split = c("median", "mean", "forceEqual",
  "cutEqual", "quartiles"), paired = FALSE, AND = TRUE,
  test.edges = FALSE, edges, progressbar = TRUE)
}
\arguments{
\item{input}{a matrix or data frame of observations (not a network/edgelist).
See included example datasets \code{\link{depression}} and \code{\link{social}}.}

\item{it}{the number of iterations (permutations) in each network comparison test}

\item{gamma}{the sparsity parameter used in generating networks. Defaults to 0.5 for interval data
and 0.25 for binary data}

\item{nodes}{indicates which nodes should be tested. Can be given
as a character string of desired nodes (e.g., c("node1","node2")) or as a numeric vector of
column numbers (e.g., c(1,2)).}

\item{binary.data}{logical. Indicates whether the input data is binary}

\item{weighted}{logical. Indicates whether resultant networks preserve edge weights or binarize edges.}

\item{split}{method by which to split network given non-binary data. "median": median split (excluding the median),
"mean": mean split, "forceEqual": creates equally sized groups by partitioning random median observations
 to the smaller group, "cutEqual": creates equally sized groups by deleting random values
 from the bigger group,"quartile": uses the top and bottom quartile as groups
(paired, AND, test.edges, edges, progressbar)}

\item{paired}{Logical. Can be TRUE of FALSE to indicate whether the samples are dependent or not. If paired is TRUE, relabeling is performed within each pair of observations. If paired is FALSE, relabeling is not restricted to pairs of observations. Note that, currently, dependent data is assumed to entail one group measured twice.}

\item{AND}{Logical. Can be TRUE of FALSE to indicate whether the AND-rule or the OR-rule should be used to define the edges in the network. Defaults to TRUE. Only necessary for binary data.}

\item{test.edges}{Logical. Can be TRUE of FALSE to indicate whether or not differences in individual edges should be tested.}

\item{edges}{Character or list. When 'all', differences between all individual edges are tested. When provided a list with one or more pairs of indices referring to variables, the provided edges are tested. A Holm-Bonferroni correction is applied to control for multiple testing.}

\item{progressbar}{Logical. Should the pbar be plotted in order to see the progress of the estimation procedure? Defaults to TRUE.}
}
\value{
\code{\link{impact}} returns a list where each element is an object of class \code{NCT}
}
\description{
This function wraps the function \code{NCT} from the \link{NetworkComparisonTest} package
to provide an explicit test for the significance of node impacts.
}
\details{
The NCT method is computationally intensive. It is recommended that users test a subset of nodes
at a time using the \code{nodes} argument, rather than testing all nodes simultaneously.



In order to be interpreted in a meaningful way, the significance of impact statistics should be explicitly tested.

The \link{NCT} function from the \link{NetworkComparisonTest} uses a permutation test to determine the significance
of structure invariances between two networks. Because impact statistics are mathematically defined as structural invariance between
two networks, \code{NCT} is an appropriate method to test the significance of impact statistics.

\code{impact.NCT} returns an object of class \code{NCT}, which includes p-values for invariances.
}
\examples{
out <- impact.NCT(depression[,1:5], it=5, nodes="psychomotor_retardation")
\donttest{
NCT1 <- impact.NCT(depression, it=25, nodes="psychomotor_retardation")
NCT1$psychomotor_retardation$glstrinv.pval
NCT1$psychomotor_retardation$nwinv.pval
## Both significant

NCT2 <- impact.NCT(social, it=25, nodes="Kim", binary.data=TRUE)
NCT2$Kim$glstrinv.pval
NCT2$Kim$nwinv.pval
## Only global strength impact is significant

##Note: for speed, 25 permutations are iterated here; more permutations are necessary in practice
}
}
