% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nv_collections.R
\name{nv_collection}
\alias{nv_collection}
\title{Neurovault Collections}
\usage{
nv_collection(id = NULL, doi = NULL, owner = NULL, name = NULL,
  verbose = TRUE, secure = TRUE, max_count = Inf, ...)
}
\arguments{
\item{id}{id of the collection}

\item{doi}{Digital Object Identifier (DOI) for the project or collection}

\item{owner}{owner of the collection}

\item{name}{name of the collection}

\item{verbose}{print diagnostic messages}

\item{secure}{passed to \code{\link{nv_base_url}} for https}

\item{max_count}{Maximum count of records to call, the number of records
may be larger than this based on how the limits are set for API calls}

\item{...}{additional options to pass to \code{\link{GET}}}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Returns a  list of dictionaries with information corresponding
to each collection stored in NeuroVault.
Results can be filtered by specifying the name, DOI or owner of the collection.
}
\note{
See \url{https://neurovault.org/api-docs}
}
\examples{
res = nv_collection(doi = "10.1016/j.neurobiolaging.2012.11.002")
res = nv_collection(name = "21 pain studies (NIDM-Results)")
res = nv_collection(id = 77)
res = nv_collection(id = 77, doi = "10.1016/j.neurobiolaging.2012.11.002")
res = nv_collection(max_count = 100)

}
