#' Hongite Mineralogy
#'
#' Mineral compositions of 25 specimens of hongite.
#' @format A [`data.frame`] with 5 variables (minerals):
#'  \describe{
#'    \item{`A`}{Albite (weight percent).}
#'    \item{`B`}{Blandite (weight percent).}
#'    \item{`C`}{Cornite (weight percent).}
#'    \item{`D`}{Daubite (weight percent).}
#'    \item{`E`}{Endite (weight percent).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"hongite"

#' Kongite Mineralogy
#'
#' Mineral compositions of 25 specimens of kongite.
#' @format A [`data.frame`] with 5 variables (minerals):
#'  \describe{
#'    \item{`A`}{Albite (weight percent).}
#'    \item{`B`}{Blandite (weight percent).}
#'    \item{`C`}{Cornite (weight percent).}
#'    \item{`D`}{Daubite (weight percent).}
#'    \item{`E`}{Endite (weight percent).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"kongite"

#' Boxite Mineralogy
#'
#' Mineral compositions and depths of 25 specimens of boxite.
#' @format A [`data.frame`] with 5 variables (minerals):
#'  \describe{
#'    \item{`A`}{Albite (weight percent).}
#'    \item{`B`}{Blandite (weight percent).}
#'    \item{`C`}{Cornite (weight percent).}
#'    \item{`D`}{Daubite (weight percent).}
#'    \item{`E`}{Endite (weight percent).}
#'    \item{`depth`}{Depth (meter).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"boxite"

#' Coxite Mineralogy
#'
#' Mineral compositions, depths and porosity of 25 specimens of coxite.
#' @format A [`data.frame`] with 5 variables (minerals):
#'  \describe{
#'    \item{`A`}{Albite (weight percent).}
#'    \item{`B`}{Blandite (weight percent).}
#'    \item{`C`}{Cornite (weight percent).}
#'    \item{`D`}{Daubite (weight percent).}
#'    \item{`E`}{Endite (weight percent).}
#'    \item{`depth`}{Depth (meter).}
#'    \item{`porosity`}{Porosity (percent).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"coxite"

#' Arctic Lake
#'
#' Sand, silt, clay compositions of 39 sediment samples at different water
#' depths in an Arctic lake.
#' @format A [`data.frame`] with 4 variables:
#'  \describe{
#'    \item{`sand`}{Sand content (percent).}
#'    \item{`silt`}{Silt content (percent).}
#'    \item{`clay`}{Clay content (percent).}
#'    \item{`depth`}{Water depth (m).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"arctic"

#' Skye Lavas Compositions
#'
#' Chemical compositions of 23 aphyric Skye lavas.
#' @format A [`data.frame`] with 3 variables (percent):
#'  \describe{
#'    \item{`A`}{Na2O + K2O.}
#'    \item{`F`}{Fe2O3.}
#'    \item{`M`}{MgO.}
#'  }
#' @source
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall. \doi{10.1007/978-94-009-4109-0}.
#' @family datasets
#' @keywords datasets
"lava"

#' Predator-Prey Compositions
#'
#' Predator-prey compositions at 25 different sites.
#' @format A [`data.frame`] with 3 variables (proportions):
#'  \describe{
#'    \item{`P`}{Predator.}
#'    \item{`Q`}{Prey of species Q.}
#'    \item{`R`}{Prey of species R.}
#'  }
#' @source
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall. \doi{10.1007/978-94-009-4109-0}.
#' @family datasets
#' @keywords datasets
"predator"

#' Thin Sections Compositions
#'
#' Mineral compositions of five slides as reported by five analysts.
#' @format A [`data.frame`] with 9 variables:
#'  \describe{
#'    \item{`analyst`}{Analyst number.}
#'    \item{`slide`}{Slide number.}
#'    \item{`quartz`}{Quartz (percent).}
#'    \item{`microcline`}{Microcline (percent).}
#'    \item{`plagioclass`}{Plagioclass (percent).}
#'    \item{`biotite`}{Biotite (percent).}
#'    \item{`muscovite`}{Muscovite (percent).}
#'    \item{`opaques`}{Opaque minerals (percent).}
#'    \item{`nonopaques`}{Non-opaque minerals (percent).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"slides"

# Can Sora Petrographic Data
#
# @format A [`data.frame`] with 21 variables:
#  \describe{
#    \item{VAR1}{Optical activity.}
#    \item{VAR2}{Inclusion orientation.}
#    \item{VAR3}{Void orientation.}
#    \item{VAR4}{Texture.}
#    \item{VAR5}{Special components.}
#    \item{VAR6}{Plutonic rocks.}
#    \item{VAR7}{Volcanic rocks.}
#    \item{VAR8}{Metamorphic rocks.}
#    \item{VAR9}{Sedimentary rocks.}
#    \item{VAR10}{Quartz.}
#    \item{VAR11}{Feldspar.}
#    \item{VAR12}{Plagioclase.}
#    \item{VAR13}{Pyroxenes.}
#    \item{VAR14}{Amphiboles.}
#    \item{VAR15}{Micas.}
#    \item{VAR16}{Phyllosilicates.}
#    \item{VAR17}{Carbonates.}
#    \item{VAR18}{Other constituents.}
#    \item{VAR19}{Packing.}
#  }
# @references
#  Cau, M.-A., Day, P. M., Baxter, M. J., Papageorgiou, I., Iliopoulos, I. &
#  Montana, G. (2004). Exploring Automatic Grouping Procedures in Ceramic
#  Petrology. *Journal of Archaeological Science*, 31(9): 1325-1338.
#  \doi{10.1016/j.jas.2004.03.006}.
# @family datasets
# @keywords datasets
#"petrography"

# Can Sora Chemical Data
#
# @format A [`data.frame`] with 30 variables.
# @references
#  Cau, M.-A. (1999). Importaciones de cerámica tardorromana de cocina en las
#  Iles Balears: el caso de Can Sora (Eivissa). In J. Capel Martinez,
#  *Arqueometria y Arqueologia*, p. 197-219. Granada: Editorial Universidad de
#  Granada. Monografica Arte y Arqueología 47.
# @family datasets
# @keywords datasets
#"chemistry"
