% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GroupedLogRatio-class}
\alias{GroupedLogRatio-class}
\alias{GroupedLR-class}
\alias{.GroupedLR}
\alias{GroupedCLR-class}
\alias{.GroupedCLR}
\alias{GroupedALR-class}
\alias{.GroupedALR}
\alias{GroupedILR-class}
\alias{.GroupedILR}
\alias{GroupedPLR-class}
\alias{.GroupedPLR}
\title{Grouped Log-Ratio Matrix}
\description{
An S4 class to represent grouped log-ratio.
}
\note{
This class inherits from \code{\linkS4class{LogRatio}} and
\code{\linkS4class{ReferenceGroups}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{GroupedLogRatio} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## codaccess
dim(coda) # Get the matrix dimensions
row(coda) # Get the row indexes
col(coda, as.factor = TRUE) # Get the column indexes
nrow(coda) # Get the number of rows
ncol(coda) # Get the number of columns
dimnames(coda) # Get the dimension names
rownames(coda) <- LETTERS[1:25] # Set the row names
rownames(coda) # Get the rownames
colnames(coda) <- letters[21:25] # Set the column names
colnames(coda) # Get the column names
}
\seealso{
Other classes: 
\code{\link{CompositionMatrix-class}},
\code{\link{GroupedComposition-class}},
\code{\link{LogRatio-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OutlierIndex-class}},
\code{\link{ReferenceGroups-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
