% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read}
\alias{read}
\title{Reads an nfer event file into an R dataframe.}
\usage{
read(event_file)
}
\arguments{
\item{event_file}{The name of the file containing nfer formatted events.}
}
\value{
A dataframe containing the events.
}
\description{
The nfer event format is not read easily into R.  This function
essentially simplifies sharing event traces between the nfer
command-line tool and the R package.
}
\details{
Nfer event files are formatted as follows:
Each row is a pipe-separated list of either 2 or 4 values represents one event.
The first column is the event name.  The second is the event timestamp (integer).
The third and fourth columns are used when the event carries data.
The third column is a semicolon separated list of data keys.
The fourth column is a semicolon separate list of data values in the same order
as the keys.

Example event file contents: \preformatted{
foo|123|x|2
bar|987|x;y|3;true
}

The result of reading such a file with this function is a dataframe where the
first column contains event names, the second contains event timestamps, and
subsequent columns contain data.  The data is formatted with one column per name.
Events that don't carry some data key will have an NA value for that column.

Resulting dataframe of event: \preformatted{
| name | timestamp | x |    y |
-------------------------------
| foo  | 123       | 2 | NA   |
| bar  | 987       | 3 | TRUE |
}
}
\examples{
events <- nfer::read(system.file("extdata", "ops.events", package = "nfer"))
}
