% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nflverse.R
\name{load_espn_qbr}
\alias{load_espn_qbr}
\title{Load ESPN's QBR}
\usage{
load_espn_qbr(
  league = c("nfl", "college"),
  seasons = most_recent_season(),
  summary_type = c("season", "weekly")
)
}
\arguments{
\item{league}{One of "nfl" or "college", defaults to "nfl"}

\item{seasons}{a numeric vector of seasons to return, data available since 2006. Defaults to latest season available. TRUE will select all seasons.}

\item{summary_type}{One of "season" or "weekly", defaults to season}
}
\value{
a tibble of season-level injury report data.
}
\description{
Load ESPN's QBR
}
\examples{
\donttest{
    load_espn_qbr("nfl",2020)
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_espn_qbr.html} for a web version of the dictionary

\code{\link{dictionary_espn_qbr}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/espnscrapeR-data}
}
