% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_url.R
\name{progressively}
\alias{progressively}
\title{Progressively}
\usage{
progressively(f, p = NULL)
}
\arguments{
\item{f}{a function to add progressr functionality to.}

\item{p}{a progressor function as created by \code{progressr::progressor()}}
}
\value{
a function that does the same as \code{f} but it calls \code{p()} after iteration.
}
\description{
This function helps add progress-reporting to any function - given function \code{f()} and progressor \code{p()}, it will return a new function that calls \code{f()} and then (on-exiting) will call \code{p()} after every iteration.
}
\details{
This is inspired by purrr's \code{safely}, \code{quietly}, and \code{possibly} function decorators.
}
\examples{

\donttest{
try({ # prevents cran errors

read_rosters <- function(){
  urls <- c("https://github.com/nflverse/nflfastR-roster/raw/master/data/seasons/roster_2020.csv",
            "https://github.com/nflverse/nflfastR-roster/raw/master/data/seasons/roster_2021.csv")

  p <- progressr::progressor(along = urls)
  lapply(urls, progressively(read.csv, p))
}

progressr::with_progress(read_rosters())

})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/exporting_nflreadr.html} for vignette on exporting nflreadr in packages
}
