% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_url.R
\name{load_from_url}
\alias{load_from_url}
\title{Load any rds/csv/csv.gz/parquet/qs file from a remote URL}
\usage{
load_from_url(url, ..., seasons = TRUE, nflverse = FALSE)
}
\arguments{
\item{url}{a vector of URLs to load into memory. If more than one URL provided, will row-bind them.}

\item{...}{named arguments that will be added as attributes to the data, e.g. \code{nflverse_type} = "pbp"}

\item{seasons}{a numeric vector of years that will be used to filter the dataframe's \code{season} column. If \code{TRUE} (default), does not filter.}

\item{nflverse}{TRUE to add nflverse_data classing and attributes.}
}
\value{
a dataframe, possibly of type \code{nflverse_data}
}
\description{
Load any rds/csv/csv.gz/parquet/qs file from a remote URL
}
\examples{
\donttest{
try({ # prevents cran errors
  urls <- c("https://github.com/nflverse/nflverse-data/releases/download/rosters/roster_2020.csv",
            "https://github.com/nflverse/nflverse-data/releases/download/rosters/roster_2021.csv")
 load_from_url(urls, nflverse = TRUE, nflverse_type = "rosters for 2020 & 2021")
})
}
}
