% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_join_coalesce.R
\name{join_coalesce}
\alias{join_coalesce}
\title{Coalescing join}
\usage{
join_coalesce(
  x,
  y,
  by = NULL,
  type = c("left", "inner", "full"),
  ...,
  by.x = NULL,
  by.y = NULL,
  sort = TRUE,
  incomparables = c(NA, NaN)
)
}
\arguments{
\item{x, y}{dataframes. Will be coerced to data.table}

\item{by}{keys to join on, as a plain or named character vector}

\item{type}{one of "left" (all rows of x and matching rows of y),
"inner" (matching rows of x and y), "full" (all rows of x and y)}

\item{...}{other args passed to \code{merge.data.frame()}}

\item{by.x, by.y}{alternate form of keys to join on - if provided, will override \code{by}.}

\item{sort}{whether to sort output by the join keys}

\item{incomparables}{keys to NOT match on, i.e. NA should not match on NA.}
}
\value{
a data.frame joining x and y dataframes together, with every column from
both x and y and patching NA values in x with those in y.
}
\description{
EXPERIMENTAL! This function joins two dataframes together by key, and then coalesces any
columns that have shared names (i.e. fills in NAs). A utility function primarily
used internally within nflverse to help build player IDs
}
\examples{
\dontshow{.for_cran()}
x <- data.frame(id1 = c(NA_character_,letters[1:4]), a = c(1,NA,3,NA,5), b = 1:5 * 10)
y <- data.frame(id2 = c(letters[3:11],NA_character_), a = -(1:10), c = 1:10 * 100)

join_coalesce(x,y, by = c("id1"="id2"))
join_coalesce(x,y, by.x = "id1", by.y = "id2")
join_coalesce(x,y, by = c("id1"="id2"), type = "inner")
join_coalesce(x,y, by = c("id1"="id2"), type = "full")

}
