% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updates_and_reports.R
\name{nflverse_sitrep}
\alias{nflverse_sitrep}
\title{Get a Situation Report on System, nflverse/ffverse Package Versions and Dependencies}
\usage{
nflverse_sitrep(
  pkg = c("nflreadr", "nflfastR", "nflseedR", "nfl4th", "nflplotR", "nflverse"),
  recursive = TRUE
)
}
\arguments{
\item{pkg}{a character vector naming installed packages, or \code{NULL}
(the default) meaning all nflverse packages. The function checks internally
if all packages are installed and informs if that is not the case.}

\item{recursive}{a logical indicating whether dependencies of \code{pkg} and their
dependencies (and so on) should be included.
Can also be a character vector listing the types of dependencies, a subset
of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector, character string
\code{"most"} for the same vector without \code{"Enhances"}, character string \code{"strong"}
(default) for the first three elements of that vector.}
}
\value{
Returns \code{NULL} invisibly. Called for side effects.
}
\description{
This function gives a quick overview of the versions of R and the operating
system as well as the versions of nflverse/ffverse packages and their dependencies.
It's primarily designed to help you get a quick idea of what's going on when
you're helping someone else debug a problem.
}
\examples{
\donttest{
try(
nflverse_sitrep()
)
}
}
