% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTableVars}
\alias{nhanesTableVars}
\title{Displays a list of variables in the specified NHANES table.}
\usage{
nhanesTableVars(nh_surveygroup, nh_table, details = FALSE, nchar = 100,
  namesonly = FALSE)
}
\arguments{
\item{nh_surveygroup}{The type of survey (DEMOGRAPHICS, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE).
Abbreviated terms may also be used: (DEMO, DIET, EXAM, LAB, Q).}

\item{nh_table}{The name of the specific table to retrieve.}

\item{details}{If TRUE then only the variable names and descriptions are returned, which is often sufficient.}

\item{nchar}{The number of characters in the Variable Description to print. Values are limited to 0<=nchar<=128.
This is used to enhance readability, cause variable descriptions can be very long.}

\item{namesonly}{If TRUE then only the variable names are returned.}
}
\value{
The names of the tables in the specified survey group
}
\description{
Enables quick display of table variables and their definitions.
}
\details{
Data are retrieved via web scraping using html wrappers from package rvest.
Each data table contains multiple, sometimes more than 100, fields. It is helpful to list the field
descriptions to ascertain quickly if a data table is of interest.
}
\examples{
nhanesTableVars('LAB', 'CBC_E')
nhanesTableVars('EXAM', 'OHX_E', details=TRUE, nchar=50)
nhanesTableVars('DEMO', 'DEMO_F', namesonly = TRUE)
}

