% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{nhd_plus_load}
\alias{nhd_plus_load}
\title{Load NHDplus layers into current session}
\usage{
nhd_plus_load(vpu, component = "NHDSnapshot", dsn, file_ext = NA,
  approve_all_dl = FALSE, force_dl = FALSE, pretty = FALSE, ...)
}
\arguments{
\item{vpu}{numeric vector processing unit}

\item{component}{character component name}

\item{dsn}{data source name}

\item{file_ext}{character choice of "shp" for spatial data and
"dbf" for non-spatial. optional}

\item{approve_all_dl}{logical blanket approval to download all missing data. Defaults to TRUE if session is non-interactive}

\item{force_dl}{logical force a re-download of the requested data}

\item{pretty}{more minimal pretty printing st_read relative to "quiet"}

\item{...}{parameters passed on to sf::st_read}
}
\value{
spatial object
}
\description{
Load NHDplus layers into current session
}
\details{
This function will ask the user to approve downloading missing data
unless approve_all_dl is set to TRUE. Output of this function is saved in
active memory (memoized) to speed up repeated function calls.
}
\examples{
\dontrun{
# Spatial
dt <- nhd_plus_load(4, "NHDSnapshot", "NHDWaterbody")
dt <- nhd_plus_load(c(1,2), "NHDSnapshot", "NHDWaterbody")
dt <- nhd_plus_load(4, "NHDSnapshot", "NHDFlowline")
dt <- nhd_plus_load(4, "NHDPlusCatchment", "Catchment")

# Quieter printing
dt <- nhd_plus_load(4, "NHDSnapshot", "NHDWaterbody", pretty = TRUE)
# Quietest printing
dt <- nhd_plus_load(4, "NHDSnapshot", "NHDWaterbody", quiet = TRUE)

# Non-spatial
dt <- nhd_plus_load(1, "NHDPlusAttributes", "PlusFlow")
dt <- nhd_plus_load("National", "V1_To_V2_Crosswalk",
 "NHDPlusV1Network_V2Network_Crosswalk")
gridcode      <- nhd_plus_load(1, "NHDPlusCatchment", "featuregridcode")
flowline_vaa  <- nhd_plus_load(1, "NHDPlusAttributes", "PlusFlowlineVAA")
eromflow      <- nhd_plus_load(4, "EROMExtension", "EROM_010001")

# Character VPU
plusflow <- nhd_plus_load(vpu = "10L", "NHDPlusAttributes", "PlusFlow")
}
}
