% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_log.R
\name{make_log}
\alias{make_log}
\title{Create a log message}
\usage{
make_log(msg, ..., type = "I", dtFormat = getOption("nhlapi_log_datetime"),
  newLine = FALSE, sep = " | ", collapse = " ", lineBreak = "$",
  endNewLine = FALSE)
}
\arguments{
\item{msg}{\code{character(1)}, to be logged.}

\item{...}{additional \code{character()} strings to be logged. Will be
pasted to \code{msg} and collapsed using the \code{collapse} argument.}

\item{type}{\code{character(1)} ideally 1 uppercase letter.}

\item{dtFormat}{\code{character(1)}, passed to format for \code{[Sys.time()]}}

\item{newLine}{\code{logical(1)}, if \code{TRUE}, new line will be pasted.
to the beginning of the message.}

\item{sep}{\code{character(1) string}, to separate parts of the message.}

\item{collapse}{\code{character(1)}, to collapse \code{msg} and \code{...}.}

\item{lineBreak}{\code{character(1)}, replacing line breaks in \code{msg}.}

\item{endNewLine}{\code{logical(1)}, if \code{TRUE}, new line will be
pasted to the end of the message.}
}
\value{
\code{character(1)}, constructed log message.
}
\description{
Create a log message
}
\examples{
  nhlapi:::make_log("Dummy warning", type = "W")
}
