% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sc_linear.R
\name{draw_sc_linear}
\alias{draw_sc_linear}
\title{Special case: Simulate from a non homogeneous Poisson Point Process (NHPPP) from
(t_min, t_max) with linear intensity function (inversion method)}
\usage{
draw_sc_linear(
  alpha = 1,
  beta = 0,
  range_t = c(0, 10),
  rng_stream = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{alpha}{(double) the intercept}

\item{beta}{(double) the slope}

\item{range_t}{(vector, double) min and max of the time interval}

\item{rng_stream}{(\code{rstream}) an \code{rstream} object.}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times (t_); if no events realize,
a vector of length 0
}
\description{
Sample NHPPP times from a linear intensity function
using the inversion method, optionally using an \code{rstream}
generator
}
\examples{
x <- draw_sc_linear(alpha = 0, beta = 0.2)

}
